/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ext;

import java.awt.Frame;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sf.apptools.Platform;
import net.sf.apptools.actions.AbstractUserAction;
import net.sf.apptools.actions.ActionSet;
import net.sf.apptools.actions.UserAction;
import net.sf.apptools.plugin.ActivePlugIn;
import net.sf.apptools.plugin.PlugInException;
import net.sf.apptools.ui.swing.SwingWorkbenchUI;
import net.sf.apptools.ui.swing.plugin.PlugInManagerDialog;
import net.sf.apptools.ui.swing.utils.GUIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlugInManagerPlugIn
implements ActivePlugIn {
    Platform platform;

    public static String getBriefDescription() {
        return "Plug-in Manager";
    }

    public static String getLongDescription() {
        return "Adds a Plug-in manager dialog option to the Workbench";
    }

    public Map<String, String> getPlugInRequirements() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(SwingWorkbenchUI.class.getName(), "1.0.0");
        return m;
    }

    public void setup(Platform pf) throws PlugInException {
        this.platform = pf;
        final Frame frame = ((SwingWorkbenchUI)this.platform.getPlugInInstance(SwingWorkbenchUI.class)).getFrame();
        if (frame == null) {
            throw new PlugInException("Could not find the Workbench");
        }
        String managePluginsCaption = "Plug-ins...";
        String managePluginsTooltip = "Manage plug-in extensions";
        AbstractUserAction managePlugins = new AbstractUserAction(managePluginsCaption, managePluginsTooltip){

            public void execute() {
                File store = PlugInManagerPlugIn.this.platform.getPlugInAutoLoadFile();
                PlugInManagerDialog d = new PlugInManagerDialog(PlugInManagerPlugIn.this.platform, frame, PlugInManagerPlugIn.this.platform.getPlugInManager(), PlugInManagerPlugIn.this.platform.getPreferredPlugInLoader(false), store);
                d.setLocation(GUIUtils.suggestLocation(d, frame));
                d.setVisible(true);
            }
        };
        this.platform.addActionSet(new ActionSet(new UserAction[]{managePlugins}, "Options", (ActivePlugIn)this));
    }

    public boolean teardown() {
        this.platform.removeActionSets((ActivePlugIn)this);
        return false;
    }

    public String getVersion() {
        return "1.0.0";
    }
}

