/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.utils;

import org.moltools.lib.seq.alphabet.DegenerateNAAlphabet;
import org.moltools.lib.seq.alphabet.Nucleotide;
import org.moltools.lib.seq.alphabet.Symbol;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

public class SequenceMatcher {
    public static final char[][] symbolTable;
    public static final char[][] containerTable;

    public static boolean isMatch(char symbol, char[] testsymbols) {
        int i;
        char[] symbols1 = symbolTable[symbol];
        boolean match = true;
        int length = 0;
        for (int i2 = 0; i2 < testsymbols.length; ++i2) {
            char[] poss = symbolTable[testsymbols[i2]];
            length += poss.length;
            for (int s = 0; s < poss.length; ++s) {
                if (SequenceMatcher.contains(symbols1, poss[s])) continue;
                match = false;
            }
        }
        if (!match) {
            return false;
        }
        char[] symbols2 = new char[length];
        length = 0;
        for (i = 0; i < testsymbols.length; ++i) {
            char[] poss = symbolTable[testsymbols[i]];
            for (int s = 0; s < poss.length; ++s) {
                symbols2[length++] = poss[s];
            }
        }
        for (i = 0; i < symbols1.length; ++i) {
            if (SequenceMatcher.contains(symbols2, symbols1[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(char[] symbols, char symbol) {
        for (int i = 0; i < symbols.length; ++i) {
            if (symbols[i] != symbol) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(char[] symbols, char symbol) {
        char[] all = NucleotideSequenceHandler.getPossibleSymbols((char)symbol, (byte)0);
        for (int i = 0; i < all.length; ++i) {
            boolean contains = false;
            for (int j = 0; j < symbols.length; ++j) {
                if (all[i] != symbols[j]) continue;
                contains = true;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(String s1, String s2, boolean degenerate) {
        if (s1.length() < s2.length()) {
            return false;
        }
        for (int i = 0; i < s2.length(); ++i) {
            char s1c = s1.charAt(i);
            char s2c = s2.charAt(i);
            if (degenerate) {
                char[] poss = symbolTable[s1c];
                boolean contains = false;
                for (int p = 0; p < poss.length; ++p) {
                    if (!SequenceMatcher.contains(symbolTable[s2c], poss[p])) continue;
                    contains = true;
                }
                if (contains) continue;
                return false;
            }
            if (SequenceMatcher.contains(symbolTable[s2c], s1c) || SequenceMatcher.isMatch(s2c, symbolTable[s1c])) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(String seq, String str, int start, boolean degenerate) {
        if (start < 0 || start > seq.length()) {
            throw new IllegalArgumentException("indexOf: Invalid start index: " + start);
        }
        for (int i = start; i < seq.length(); ++i) {
            if (!SequenceMatcher.startsWith(seq.substring(i), str, degenerate)) continue;
            return i;
        }
        return -1;
    }

    static {
        Nucleotide nt;
        int i;
        symbolTable = new char[127][];
        containerTable = new char[127][];
        Symbol[] symbols = DegenerateNAAlphabet.getAlphabet().getSymbols();
        for (i = 0; i < symbols.length; ++i) {
            nt = (Nucleotide)symbols[i];
            if (nt.getType() != 0) continue;
            SequenceMatcher.symbolTable[nt.getChar()] = NucleotideSequenceHandler.getPossibleSymbols((char)nt.getChar(), (byte)0);
        }
        for (i = 0; i < symbols.length; ++i) {
            nt = (Nucleotide)symbols[i];
            if (nt.getType() != 0) continue;
            char c1 = nt.getChar();
            StringBuffer str = new StringBuffer();
            for (int j = 0; j < symbols.length; ++j) {
                char c2;
                Nucleotide nt2 = (Nucleotide)symbols[j];
                if (nt2.getType() != 0 || !SequenceMatcher.containsAll(symbolTable[c2 = nt2.getChar()], c1)) continue;
                str.append(c2);
            }
            SequenceMatcher.containerTable[c1] = new String(str).toCharArray();
        }
    }
}

