/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.seq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections.CollectionUtils;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.impl.TSSPair;
import org.moltools.design.data.impl.SimpleProperty;
import org.moltools.design.properties.Property;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.utils.DesignUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeMakerPropertyUtils
extends DesignUtils {
    public static final String KEY_RANK = "rank";
    public static final String KEY_MESSAGE = "message";
    public static final String KEY_TM = "tm_complement";

    public static void addMessage(PropertyAcceptor pa, Message m) {
        pa.getMutablePropertySet().addProperty((Property)new SimpleProperty(KEY_MESSAGE, (Object)m, true));
    }

    public static void clearMessages(PropertyAcceptor pa) {
        pa.getMutablePropertySet().removeProperties(KEY_MESSAGE);
    }

    public static Collection<Message> getAllMessages(PropertyHolder mh) {
        ArrayList<Message> l = new ArrayList<Message>();
        if (mh instanceof Probe) {
            Probe probe = (Probe)mh;
            l.addAll(ProbeMakerPropertyUtils.getAllMessages(probe.getTSSPair()));
        } else if (mh instanceof TSSPair) {
            TSSPair pair = (TSSPair)mh;
            if (pair.getFivePrime() != null) {
                l.addAll(ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)pair.getFivePrime()));
            }
            if (pair.getThreePrime() != null) {
                l.addAll(ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)pair.getThreePrime()));
            }
        }
        l.addAll(ProbeMakerPropertyUtils.getOwnMessages(mh));
        Collection messages = CollectionUtils.unmodifiableCollection(l);
        return messages;
    }

    public static Collection<Message> getOwnMessages(PropertyHolder pa) {
        Collection<Object> c = pa.getPropertySet().getMultiPropertyValues(KEY_MESSAGE);
        if (c == null) {
            c = Collections.emptySet();
        }
        Collection messages = CollectionUtils.unmodifiableCollection((Collection)c);
        return messages;
    }

    public static float getHybridizationTemp(PropertyHolder pa) {
        Float tmValue = (Float)pa.getPropertySet().getSinglePropertyValue(KEY_TM);
        if (tmValue == null) {
            return Float.NaN;
        }
        return tmValue.floatValue();
    }

    public static void setHybridizationTemp(PropertyAcceptor pa, float temp) {
        pa.getMutablePropertySet().setProperty((Property)new SimpleProperty(KEY_TM, (Object)new Float(temp), false));
    }

    public static short getRank(PropertyHolder c) {
        Short rankValue = (Short)c.getPropertySet().getSinglePropertyValue(KEY_RANK);
        if (rankValue == null) {
            return 0;
        }
        return rankValue;
    }

    public static void setRank(PropertyAcceptor c, short rank) {
        c.getMutablePropertySet().setProperty((Property)new SimpleProperty(KEY_RANK, (Object)new Short(rank), false));
    }
}

