/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.io.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Map;
import net.sf.apptools.textio.DataMapBuilder;
import net.sf.apptools.textio.DataMapInput;
import net.sf.apptools.textio.InputMapping;
import net.sf.apptools.textio.OutputMapping;
import net.sf.apptools.textio.impl.SimpleDelimitedOutput;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.io.SequenceDataReader;
import org.moltools.lib.seq.io.SequenceWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextTableFormatter<S extends Sequence>
implements SequenceDataReader,
SequenceWriter<S>,
DataMapInput {
    public static final String IN_DELIMITER_PATTERN = "[\t;]";
    public static final String OUT_DELIMITER = "\t";
    public static final String COMMENT_LINE_PREFIX = "#";
    protected InputMapping inputMapping;
    protected DataMapBuilder<S> mapBuilder;
    protected OutputMapping outputMapping;
    private SimpleDelimitedOutput output = new SimpleDelimitedOutput("\t");
    private BufferedReader br;

    public TextTableFormatter(InputMapping inMapping, DataMapBuilder<S> outMapBuilder, OutputMapping outMapping) {
        this.inputMapping = inMapping;
        this.outputMapping = outMapping;
        this.mapBuilder = outMapBuilder;
    }

    @Override
    public Map<String, String> readNextFormattedSequence(BufferedReader r) throws IOException {
        boolean done = false;
        String line = "";
        while (!done) {
            line = r.readLine();
            if (line == null) {
                done = true;
                continue;
            }
            if (line.length() <= 0 || line.startsWith(COMMENT_LINE_PREFIX)) continue;
            String[] record = line.split(IN_DELIMITER_PATTERN);
            return this.inputMapping.createMapForRecord(record);
        }
        return null;
    }

    @Override
    public void writeSequence(PrintWriter ps, S s) {
        Map map = this.mapBuilder.createDataMap(s);
        this.writeDataMap(ps, map);
    }

    public void writeDataMap(PrintWriter pw, Map<String, String> dataMap) {
        String[] record = this.outputMapping.createRecord(dataMap);
        pw.println(this.output.getLine(record));
    }

    public Map<String, String> getNextDataMap() throws IOException {
        return this.readNextFormattedSequence(this.br);
    }

    public void setReader(Reader in) {
        this.br = new BufferedReader(in);
    }
}

