/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.data;

import net.sf.apptools.data.AbstractDataDescriptor;
import net.sf.apptools.data.ConvertibleDataDescriptor;
import org.apache.commons.beanutils.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionDescriptor
extends AbstractDataDescriptor
implements ConvertibleDataDescriptor {
    protected String[] options;

    public OptionDescriptor(String name, String description, String propertyName, String[] options, boolean required) {
        super(name, description, propertyName, required);
        this.options = options;
    }

    @Override
    public Class<?> getDataType() {
        return Integer.class;
    }

    public String[] getOptions() {
        return this.options;
    }

    @Override
    public Converter getToValueConverter() {
        return new OptionConverter();
    }

    @Override
    public Converter getToStringConverter() {
        return new OptionToStringConverter();
    }

    public class OptionToStringConverter
    implements Converter {
        public Object convert(Class type, Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return value;
            }
            if (value instanceof Integer) {
                return OptionDescriptor.this.options[(Integer)value];
            }
            return null;
        }
    }

    public class OptionConverter
    implements Converter {
        public Object convert(Class type, Object value) {
            if (value instanceof String) {
                try {
                    Integer i = new Integer(Integer.parseInt((String)value));
                    return i;
                }
                catch (NumberFormatException ex) {
                    for (int i = 0; i < OptionDescriptor.this.options.length; ++i) {
                        if (!OptionDescriptor.this.options[i].equals(value)) continue;
                        return new Integer(i);
                    }
                    return null;
                }
            }
            return value;
        }
    }
}

