/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.workbench.gui;

import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.moltools.lib.DuplicateIDException;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.db.impl.ListSequenceDB;
import org.moltools.workbench.SequenceDBTransferrable;
import org.moltools.workbench.gui.SequenceTableCellRenderer;
import org.moltools.workbench.gui.SequenceTableModel;
import org.moltools.workbench.gui.SequenceTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceTable
extends JTable {
    protected SequenceTableModel dataModel;

    protected DefiniteSequenceDB<Sequence> getSelectedSequences() throws DuplicateIDException {
        int[] rows = this.getSelectedRows();
        ListSequenceDB db = new ListSequenceDB();
        for (int i = 0; i < rows.length; ++i) {
            db.addSequence(this.dataModel.getSequenceAt(rows[i]));
        }
        return db;
    }

    public SequenceTable(SequenceTableModel model) {
        super(model);
        this.dataModel = model;
        TableColumnModel cm = this.getColumnModel();
        if (cm.getColumnCount() >= 1) {
            cm.getColumn(0).setPreferredWidth(100);
        }
        if (cm.getColumnCount() >= 2) {
            cm.getColumn(1).setPreferredWidth(300);
        }
        cm.getColumn(1).setCellEditor(new DefaultCellEditor(new SequenceTextField(true)));
        final DragSource ds = DragSource.getDefaultDragSource();
        final SequenceTable table = this;
        final DragSourceAdapter dsl = new DragSourceAdapter(){

            public void dragEnter(DragSourceDragEvent e) {
                e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }

            public void dragExit(DragSourceEvent e) {
                e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
            }
        };
        DragGestureListener dgl = new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent e) {
                try {
                    SequenceDBTransferrable trf = new SequenceDBTransferrable(SequenceTable.this.getSelectedSequences());
                    ds.startDrag(e, DragSource.DefaultCopyNoDrop, trf, dsl);
                }
                catch (RuntimeException e1) {
                    JOptionPane.showMessageDialog(table, e1.toString());
                }
                catch (DuplicateIDException e1) {
                    JOptionPane.showMessageDialog(table, e1.toString());
                }
            }
        };
        ds.createDefaultDragGestureRecognizer(this, 3, dgl);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int col) {
        if (this.dataModel.getColumnClass(col) == Sequence.class) {
            return new SequenceTableCellRenderer();
        }
        return super.getCellRenderer(row, col);
    }
}

