/*
 * Decompiled with CFR 0.152.
 */
package net.genefront.piecemaker.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.MouseInputListener;
import net.genefront.piecemaker.gui.MultiLineDisplay;
import net.genefront.piecemaker.gui.ScaleRenderer;
import net.genefront.piecemaker.gui.TargetFragmentRenderer;
import net.genefront.piecemaker.gui.TargetRenderer;
import net.genefront.piecemaker.model.FragmentSet;
import net.genefront.piecemaker.model.SelectorTarget;
import org.moltools.lib.seq.Region;
import org.moltools.lib.seq.SequenceElement;
import org.moltools.lib.seq.impl.SimpleRegion;

public class CoverageDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected JButton closeButton = new JButton();
    protected JButton updateButton = new JButton();
    protected SelectorTarget[] targets;
    protected FragmentSet[] sets;
    protected MultiLineDisplay[] displays;
    protected Font font;

    public CoverageDialog(Frame frame, SelectorTarget[] targets, FragmentSet[] sets, String title) {
        super(frame, title, false);
        this.targets = targets;
        this.sets = sets;
        this.font = Font.getFont(Collections.singletonMap(TextAttribute.SIZE, new Float(9.0f)));
        this.displays = new MultiLineDisplay[targets.length];
        this.getContentPane().setLayout(new BorderLayout());
        JPanel mainwrapper = new JPanel();
        mainwrapper.setLayout(new BoxLayout(mainwrapper, 3));
        int i = 0;
        while (i < targets.length) {
            MultiLineDisplay mld;
            GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 2, 2);
            JTextField posField = new JTextField(7);
            posField.setHorizontalAlignment(11);
            posField.setBorder(null);
            posField.setEnabled(true);
            posField.setEditable(false);
            JLabel posLabel = new JLabel("Position:");
            JLabel idlabel = new JLabel(targets[i].getID());
            this.displays[i] = mld = new MultiLineDisplay();
            mld.set((Region)new SimpleRegion(1, targets[i].length()), (float)targets[i].length() / 500.0f);
            MLDMouseListener listener = new MLDMouseListener(mld, posField, (SequenceElement)targets[i]);
            mld.addMouseMotionListener(listener);
            mld.addMouseListener(listener);
            mld.setBackground(Color.WHITE);
            mld.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
            JPanel displaywrapper = new JPanel(new GridBagLayout());
            gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0);
            displaywrapper.add((Component)idlabel, gb);
            gb.gridx = 1;
            gb.weightx = 0.0;
            gb.anchor = 12;
            displaywrapper.add((Component)posLabel, gb);
            gb.gridx = 2;
            displaywrapper.add((Component)posField, gb);
            gb.gridx = 0;
            gb.gridy = 1;
            gb.gridwidth = 3;
            gb.weightx = 1.0;
            gb.weighty = 1.0;
            gb.fill = 2;
            gb.anchor = 18;
            displaywrapper.add((Component)mld, gb);
            displaywrapper.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    super.componentResized(e);
                    int width = mld.getWidth() - mld.head - mld.tail;
                    mld.setScale((float)mld.getDisplayedRegion().length() / (float)width);
                }
            });
            mainwrapper.add(displaywrapper);
            mainwrapper.add(Box.createVerticalGlue());
            ++i;
        }
        JScrollPane scrollPane = new JScrollPane(mainwrapper);
        this.getContentPane().add((Component)scrollPane, "Center");
        JPanel buttonPane = new JPanel(new FlowLayout(3));
        buttonPane.add((Component)this.closeButton, null);
        buttonPane.add((Component)this.updateButton, null);
        buttonPane.add(new JLabel("Click and drag to zoom view. Shift-click to reset view"));
        this.closeButton.setText("Close");
        this.updateButton.setText("Update");
        this.closeButton.addActionListener(this);
        this.updateButton.addActionListener(this);
        this.getContentPane().add((Component)buttonPane, "South");
        this.setResizable(true);
        this.setModal(false);
        this.setDefaultCloseOperation(2);
        this.updateModel();
        Dimension pref = mainwrapper.getPreferredSize();
        pref.width = 500;
        pref.height = (int)(pref.getHeight() + buttonPane.getPreferredSize().getHeight() + 50.0);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(pref.width > screen.width ? screen.width : pref.width, pref.height > screen.height ? screen.height : pref.height);
    }

    protected void updateModel() {
        int i = 0;
        while (i < this.targets.length) {
            MultiLineDisplay cd = this.displays[i];
            cd.removeAllLines();
            cd.addLine(null, new ScaleRenderer(true, 2, 10, true, this.font, Color.BLACK));
            cd.addLine(this.targets[i], new TargetRenderer(5, 1, 5, Color.BLACK, Color.WHITE, Color.BLUE));
            if (this.sets[i] != null) {
                Iterator it = this.sets[i].getAllFragments().iterator();
                while (it.hasNext()) {
                    cd.addLine(it.next(), new TargetFragmentRenderer(3, 1, 1, Color.BLACK, Color.WHITE, Color.GREEN));
                }
            }
            cd.repaint();
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.dispose();
        } else if (e.getSource() == this.updateButton) {
            this.updateModel();
        }
    }

    class MLDMouseListener
    implements MouseInputListener {
        private int lastx;
        private int startx;
        private final JTextField posLabel;
        final MultiLineDisplay mld;
        final SequenceElement target;

        public MLDMouseListener(MultiLineDisplay mld, JTextField posLabel, SequenceElement target) {
            this.mld = mld;
            this.posLabel = posLabel;
            this.target = target;
        }

        public void mouseMoved(MouseEvent e) {
            int pos = this.mld.getPosition(e.getX());
            if (this.mld.range.getStart() <= pos && pos <= this.mld.range.getEnd()) {
                this.posLabel.setText(String.valueOf(pos));
            }
        }

        public void mouseExited(MouseEvent e) {
            this.posLabel.setText("");
        }

        public void mouseClicked(MouseEvent e) {
            if (e.isShiftDown()) {
                float scale = (float)this.target.length() / (float)(this.mld.getWidth() - this.mld.head - this.mld.tail);
                this.mld.set((Region)new SimpleRegion(1, this.target.length()), scale);
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.lastx = e.getX();
            int start = this.mld.getPosition(Math.min(this.startx, this.lastx));
            int end = this.mld.getPosition(Math.max(this.startx, this.lastx));
            int length = end - start + 1;
            this.mld.unsetLimits();
            if (start < end) {
                int oldlength = this.mld.range.length();
                float newscale = this.mld.scale * (float)length / (float)oldlength;
                this.mld.set((Region)new SimpleRegion(start, end), newscale);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.startx = new Integer(e.getX());
            this.lastx = new Integer(e.getX());
        }

        public void mouseDragged(MouseEvent e) {
            int pos = this.mld.getPosition(e.getX());
            if (this.mld.range.getStart() <= pos && pos <= this.mld.range.getEnd()) {
                this.posLabel.setText(String.valueOf(pos));
            }
            this.lastx = new Integer(e.getX());
            if (!e.isShiftDown()) {
                this.mld.setLimits(this.startx, this.lastx);
                this.mld.repaint();
            } else {
                int start = this.mld.getPosition(this.startx);
                int end = this.mld.getPosition(this.lastx);
                int displacement = end - start;
                this.startx = this.lastx;
                this.mld.set((Region)new SimpleRegion(this.mld.range.getStart() + displacement, this.mld.range.getEnd() + displacement), this.mld.scale);
            }
        }
    }
}

