/*
 * Decompiled with CFR 0.152.
 */
package net.genefront.piecemaker.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.genefront.piecemaker.restriction.RestrictionPattern;
import net.genefront.piecemaker.restriction.RestrictionReaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictionReactionTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    List<RestrictionReaction> reactions = new ArrayList<RestrictionReaction>();
    protected String[] columns = new String[]{"Name", "Cut patterns"};

    public void setReactions(List<RestrictionReaction> reactions) {
        this.reactions = reactions;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.reactions == null) {
            return 0;
        }
        return this.reactions.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columns[col];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex > this.reactions.size() - 1) {
            throw new IllegalArgumentException("Row index out of range");
        }
        RestrictionReaction re = this.reactions.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return re.getName();
            }
            case 1: {
                RestrictionPattern[] cp = re.getPatterns();
                String str = "";
                int i = 0;
                while (i < cp.length) {
                    if (i > 0) {
                        str = String.valueOf(str) + ", ";
                    }
                    str = String.valueOf(str) + cp[i].toString();
                    ++i;
                }
                return str;
            }
        }
        throw new IllegalArgumentException("Column index out of range");
    }
}

