package similarityValue;

import similarityValue.gui.MainWindow;
import similarityValue.Molecule;
import similarityValue.MoleculePairValue;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import java.awt.EventQueue;

public class Main {

	//1QDE is different from the rest
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		if (args.length == 0) {		
	        // Swing has its own dispatch thread, which is 
	        // distinct from the main JVM (launcher) thread.  
	        // This means that even if the (launcher) thread exited 
	        // (this) main method, the Swing GUI thread would
	        // still be running, waiting to respond to user input, etc.
	        // and if the user closes the window, then the program would
	        // continue to run (due to the live gui thread). As of Java 6, the
	        // GUI thread will automatically stop if all Components are hidden and
	        // disposed.
	        //
	        // Execute all GUI code on the event dispatch thread, even initialization:
	
	        EventQueue.invokeLater(new Runnable() {
	            public void run() {
	                new MainWindow().setVisible(true);
	            }
	        });
		}
		else if (args.length != 2) {
			System.out.println("With no arguments, this program displays a gui to let you select the two molecules.");
			System.out.println("With two arguments, this program treats each as a directory to find the pot.dx and smol.dx files for the two molecules.");
			System.out.println("-j [number] tells the program how many threads to run");
			System.out.println("-a [number] specifies a value for alpha (1 by default)");
		}
		else {
			try {
			    // Get current time
			    long start = System.currentTimeMillis();
			    long startLoading = start;
			    
				Molecule mol1 = new Molecule(new File(args[0]));
				Molecule mol2 = new Molecule(new File(args[1]));
				
				long startCalculating = System.currentTimeMillis();
			    System.out.println("# Time spent loading molecules from disk: " + ((startCalculating-startLoading)/1000.0) + " sec");
				
				System.out.println(MoleculePairValue.similarityValue(mol1, mol2));
				
				System.out.println("# Time spent calculating: " + ((System.currentTimeMillis()-startCalculating)/1000.0) + " sec");
			    System.out.println("# Total time spent: " + ((System.currentTimeMillis()-start)/1000.0) + " sec");
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

}
