/*  
 *  bits/gdl_bit_vector.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_GBIT_H__
#define __GDL_GBIT_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>

__BEGIN_DECLS

typedef char gdl_bit_slot;

#define GDL_BITMASK(b) (1 << ((b) % GDL_CHAR_BIT))
#define GDL_BITSLOT(b) ((b) / GDL_CHAR_BIT)
#define GDL_BITSET(a, b) ((a)[GDL_BITSLOT(b)] |= GDL_BITMASK(b))
#define GDL_BITCLEAR(a, b) ((a)[GDL_BITSLOT(b)] &= ~GDL_BITMASK(b))
#define GDL_BITTEST(a, b) ((a)[GDL_BITSLOT(b)] & GDL_BITMASK(b))
#define GDL_BITNSLOTS(nb) ((nb + GDL_CHAR_BIT - 1) / GDL_CHAR_BIT)

typedef struct
{
	size_t size;
	size_t slot;
	gdl_bit_slot * data;
} gdl_bit_vector;

gdl_bit_vector * gdl_bit_vector_alloc (size_t n);
gdl_bit_vector * gdl_bit_vector_clone (const gdl_bit_vector * b);
void gdl_bit_vector_free (gdl_bit_vector * b);
void gdl_bit_vector_set (gdl_bit_vector * b, size_t i);
size_t gdl_bit_vector_get (const gdl_bit_vector * b, size_t i);
void gdl_bit_vector_clear (gdl_bit_vector * b, size_t i);
gdl_bit_slot * gdl_bit_vector_slot (gdl_bit_vector * b, size_t i);
size_t gdl_bit_vector_cmp (const gdl_bit_vector * b1, const gdl_bit_vector * b2);

gdl_bit_vector * gdl_bit_vector_fread (FILE * stream);
int gdl_bit_vector_fwrite (FILE * stream, gdl_bit_vector * b);

__END_DECLS

#endif /* __GDL_GBIT__H */
