/* blas/gdl_blas.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Author:  G. Jungman
 */
#ifndef __GDL_BLAS_H__
#define __GDL_BLAS_H__

#include <gdl/gdl_common.h>

#include <gdl/gdl_vector.h>
#include <gdl/gdl_matrix.h>

#include <gdl/gdl_blas_types.h>

__BEGIN_DECLS


/* ========================================================================
 * Level 1
 * ========================================================================
 */

//int gdl_blas_sdsdot (float alpha,
//                     const gdl_vector_float * X,
//                     const gdl_vector_float * Y,
//                     float * result
//                     );
//
//int gdl_blas_dsdot (const gdl_vector_float * X,
//                    const gdl_vector_float * Y,
//                    double * result
//                    );
//
//int gdl_blas_sdot (const gdl_vector_float * X,
//                   const gdl_vector_float * Y,
//                   float * result
//                   );

int gdl_blas_ddot (const gdl_vector * X,
                   const gdl_vector * Y,
                   double * result
                   );


//int  gdl_blas_cdotu (const gdl_vector_complex_float * X,
//                     const gdl_vector_complex_float * Y,
//                     gdl_complex_float * dotu);
//
//int  gdl_blas_cdotc (const gdl_vector_complex_float * X,
//                     const gdl_vector_complex_float * Y,
//                     gdl_complex_float * dotc);
//
//int  gdl_blas_zdotu (const gdl_vector_complex * X,
//                     const gdl_vector_complex * Y,
//                     gdl_complex * dotu);
//
//int  gdl_blas_zdotc (const gdl_vector_complex * X,
//                     const gdl_vector_complex * Y,
//                     gdl_complex * dotc);


//float  gdl_blas_snrm2  (const gdl_vector_float * X);
//float  gdl_blas_sasum  (const gdl_vector_float * X);
double gdl_blas_dnrm2  (const gdl_vector * X);
double gdl_blas_dasum  (const gdl_vector * X);
//float  gdl_blas_scnrm2 (const gdl_vector_complex_float * X);
//float  gdl_blas_scasum (const gdl_vector_complex_float * X);
//double gdl_blas_dznrm2 (const gdl_vector_complex * X);
//double gdl_blas_dzasum (const gdl_vector_complex * X);


//CBLAS_INDEX_t gdl_blas_isamax (const gdl_vector_float * X);
CBLAS_INDEX_t gdl_blas_idamax (const gdl_vector * X);
//CBLAS_INDEX_t gdl_blas_icamax (const gdl_vector_complex_float * X);
//CBLAS_INDEX_t gdl_blas_izamax (const gdl_vector_complex * X);


//int  gdl_blas_sswap (gdl_vector_float * X,
//                     gdl_vector_float * Y);
//
//int  gdl_blas_scopy (const gdl_vector_float * X,
//                     gdl_vector_float * Y);
//
//int  gdl_blas_saxpy (float alpha,
//                     const gdl_vector_float * X,
//                     gdl_vector_float * Y);

int  gdl_blas_dswap (gdl_vector * X,
                     gdl_vector * Y);

int  gdl_blas_dcopy (const gdl_vector * X,
                     gdl_vector * Y);

int  gdl_blas_daxpy (double alpha,
                     const gdl_vector * X,
                     gdl_vector * Y);

//int  gdl_blas_cswap (gdl_vector_complex_float * X,
//                     gdl_vector_complex_float * Y);
//
//int  gdl_blas_ccopy (const gdl_vector_complex_float * X,
//                     gdl_vector_complex_float * Y);
//
//int  gdl_blas_caxpy (const gdl_complex_float alpha,
//                     const gdl_vector_complex_float * X,
//                     gdl_vector_complex_float * Y);
//
//int  gdl_blas_zswap (gdl_vector_complex * X,
//                     gdl_vector_complex * Y);
//
//int  gdl_blas_zcopy (const gdl_vector_complex * X,
//                     gdl_vector_complex * Y);
//
//int  gdl_blas_zaxpy (const gdl_complex alpha,
//                     const gdl_vector_complex * X,
//                     gdl_vector_complex * Y);


int  gdl_blas_srotg (float a[], float b[], float c[], float s[]);

int  gdl_blas_srotmg (float d1[], float d2[], float b1[], float b2, float P[]);

//int  gdl_blas_srot (gdl_vector_float * X,
//                    gdl_vector_float * Y,
//                    float c, float s);

//int  gdl_blas_srotm (gdl_vector_float * X,
//                     gdl_vector_float * Y,
//                     const float P[]);

int  gdl_blas_drotg (double a[], double b[], double c[], double s[]);

int  gdl_blas_drotmg (double d1[], double d2[], double b1[],
                      double b2, double P[]);

int  gdl_blas_drot (gdl_vector * X,
                    gdl_vector * Y,
                    const double c, const double s);

int  gdl_blas_drotm (gdl_vector * X,
                     gdl_vector * Y,
                     const double P[]);


//void gdl_blas_sscal  (float  alpha, gdl_vector_float * X);
void gdl_blas_dscal  (double alpha, gdl_vector * X);
//void gdl_blas_cscal  (const gdl_complex_float alpha, gdl_vector_complex_float * X);
//void gdl_blas_zscal  (const gdl_complex alpha, gdl_vector_complex * X);
//void gdl_blas_csscal (float  alpha, gdl_vector_complex_float * X);
//void gdl_blas_zdscal (double alpha, gdl_vector_complex * X);


/* ===========================================================================
 * Level 2
 * ===========================================================================
 */

/*
 * Routines with standard 4 prefixes (S, D, C, Z)
 */
//int  gdl_blas_sgemv (CBLAS_TRANSPOSE_t TransA,
//                     float alpha,
//                     const gdl_matrix_float * A,
//                     const gdl_vector_float * X,
//                     float beta,
//                     gdl_vector_float * Y);

//int  gdl_blas_strmv (CBLAS_UPLO_t Uplo,
//                     CBLAS_TRANSPOSE_t TransA, CBLAS_DIAG_t Diag,
//                     const gdl_matrix_float * A,
//                     gdl_vector_float * X);

//int  gdl_blas_strsv (CBLAS_UPLO_t Uplo,
//                     CBLAS_TRANSPOSE_t TransA, CBLAS_DIAG_t Diag,
//                     const gdl_matrix_float * A,
//                     gdl_vector_float * X);

int  gdl_blas_dgemv (CBLAS_TRANSPOSE_t TransA,
                     double alpha,
                     const gdl_matrix * A,
                     const gdl_vector * X,
                     double beta,
                     gdl_vector * Y);

int  gdl_blas_dtrmv (CBLAS_UPLO_t Uplo,
                     CBLAS_TRANSPOSE_t TransA, CBLAS_DIAG_t Diag,
                     const gdl_matrix * A,
                     gdl_vector * X);

int  gdl_blas_dtrsv (CBLAS_UPLO_t Uplo,
                     CBLAS_TRANSPOSE_t TransA, CBLAS_DIAG_t Diag,
                     const gdl_matrix * A,
                     gdl_vector * X);

//int  gdl_blas_cgemv (CBLAS_TRANSPOSE_t TransA,
//                     const gdl_complex_float alpha,
//                     const gdl_matrix_complex_float * A,
//                     const gdl_vector_complex_float * X,
//                     const gdl_complex_float beta,
//                     gdl_vector_complex_float * Y);

//int  gdl_blas_ctrmv (CBLAS_UPLO_t Uplo,
//                     CBLAS_TRANSPOSE_t TransA, CBLAS_DIAG_t Diag,
//                     const gdl_matrix_complex_float * A,
//                     gdl_vector_complex_float * X);
//
//int  gdl_blas_ctrsv (CBLAS_UPLO_t Uplo,
//                     CBLAS_TRANSPOSE_t TransA, CBLAS_DIAG_t Diag,
//                     const gdl_matrix_complex_float * A,
//                     gdl_vector_complex_float * X);
//
//int  gdl_blas_zgemv (CBLAS_TRANSPOSE_t TransA,
//                     const gdl_complex alpha,
//                     const gdl_matrix_complex * A,
//                     const gdl_vector_complex * X,
//                     const gdl_complex beta,
//                     gdl_vector_complex * Y);
//
//int  gdl_blas_ztrmv (CBLAS_UPLO_t Uplo,
//                     CBLAS_TRANSPOSE_t TransA, CBLAS_DIAG_t Diag,
//                     const gdl_matrix_complex * A,
//                     gdl_vector_complex * X);
//
//int  gdl_blas_ztrsv (CBLAS_UPLO_t Uplo,
//                     CBLAS_TRANSPOSE_t TransA, CBLAS_DIAG_t Diag,
//                     const gdl_matrix_complex * A,
//                     gdl_vector_complex *X);

/*
 * Routines with S and D prefixes only
 */
//int  gdl_blas_ssymv (CBLAS_UPLO_t Uplo,
//                     float alpha,
//                     const gdl_matrix_float * A,
//                     const gdl_vector_float * X,
//                     float beta,
//                     gdl_vector_float * Y);

//int  gdl_blas_sger (float alpha,
//                    const gdl_vector_float * X,
//                    const gdl_vector_float * Y,
//                    gdl_matrix_float * A);
//
//int  gdl_blas_ssyr (CBLAS_UPLO_t Uplo,
//                    float alpha,
//                    const gdl_vector_float * X,
//                    gdl_matrix_float * A);
//
//int  gdl_blas_ssyr2 (CBLAS_UPLO_t Uplo,
//                     float alpha,
//                     const gdl_vector_float * X,
//                     const gdl_vector_float * Y,
//                     gdl_matrix_float * A);

int  gdl_blas_dsymv (CBLAS_UPLO_t Uplo,
                     double alpha,
                     const gdl_matrix * A,
                     const gdl_vector * X,
                     double beta,
                     gdl_vector * Y);
int  gdl_blas_dger (double alpha,
                    const gdl_vector * X,
                    const gdl_vector * Y,
                    gdl_matrix * A);

int  gdl_blas_dsyr (CBLAS_UPLO_t Uplo,
                    double alpha,
                    const gdl_vector * X,
                    gdl_matrix * A);

int  gdl_blas_dsyr2 (CBLAS_UPLO_t Uplo,
                     double alpha,
                     const gdl_vector * X,
                     const gdl_vector * Y,
                     gdl_matrix * A);

/*
 * Routines with C and Z prefixes only
 */

//int  gdl_blas_chemv (CBLAS_UPLO_t Uplo,
//                     const gdl_complex_float alpha,
//                     const gdl_matrix_complex_float * A,
//                     const gdl_vector_complex_float * X,
//                     const gdl_complex_float beta,
//                     gdl_vector_complex_float * Y);
//
//int  gdl_blas_cgeru (const gdl_complex_float alpha,
//                     const gdl_vector_complex_float * X,
//                     const gdl_vector_complex_float * Y,
//                     gdl_matrix_complex_float * A);
//
//int  gdl_blas_cgerc (const gdl_complex_float alpha,
//                     const gdl_vector_complex_float * X,
//                     const gdl_vector_complex_float * Y,
//                     gdl_matrix_complex_float * A);
//
//int  gdl_blas_cher (CBLAS_UPLO_t Uplo,
//                    float alpha,
//                    const gdl_vector_complex_float * X,
//                    gdl_matrix_complex_float * A);
//
//int  gdl_blas_cher2 (CBLAS_UPLO_t Uplo,
//                     const gdl_complex_float alpha,
//                     const gdl_vector_complex_float * X,
//                     const gdl_vector_complex_float * Y,
//                     gdl_matrix_complex_float * A);
//
//int  gdl_blas_zhemv (CBLAS_UPLO_t Uplo,
//                     const gdl_complex alpha,
//                     const gdl_matrix_complex * A,
//                     const gdl_vector_complex * X,
//                     const gdl_complex beta,
//                     gdl_vector_complex * Y);
//
//int  gdl_blas_zgeru (const gdl_complex alpha,
//                     const gdl_vector_complex * X,
//                     const gdl_vector_complex * Y,
//                     gdl_matrix_complex * A);
//
//int  gdl_blas_zgerc (const gdl_complex alpha,
//                     const gdl_vector_complex * X,
//                     const gdl_vector_complex * Y,
//                     gdl_matrix_complex * A);
//
//int  gdl_blas_zher (CBLAS_UPLO_t Uplo,
//                    double alpha,
//                    const gdl_vector_complex * X,
//                    gdl_matrix_complex * A);
//
//int  gdl_blas_zher2 (CBLAS_UPLO_t Uplo,
//                     const gdl_complex alpha,
//                     const gdl_vector_complex * X,
//                     const gdl_vector_complex * Y,
//                     gdl_matrix_complex * A);

/*
 * ===========================================================================
 * Prototypes for level 3 BLAS
 * ===========================================================================
 */

/*
 * Routines with standard 4 prefixes (S, D, C, Z)
 */
//int  gdl_blas_sgemm (CBLAS_TRANSPOSE_t TransA,
//                     CBLAS_TRANSPOSE_t TransB,
//                     float alpha,
//                     const gdl_matrix_float * A,
//                     const gdl_matrix_float * B,
//                     float beta,
//                     gdl_matrix_float * C);
//
//int  gdl_blas_ssymm (CBLAS_SIDE_t Side, CBLAS_UPLO_t Uplo,
//                     float alpha,
//                     const gdl_matrix_float * A,
//                     const gdl_matrix_float * B,
//                     float beta,
//                     gdl_matrix_float * C);
//
//int  gdl_blas_ssyrk (CBLAS_UPLO_t Uplo, CBLAS_TRANSPOSE_t Trans,
//                     float alpha,
//                     const gdl_matrix_float * A,
//                     float beta,
//                     gdl_matrix_float * C);
//
//int  gdl_blas_ssyr2k (CBLAS_UPLO_t Uplo, CBLAS_TRANSPOSE_t Trans,
//                      float alpha,
//                      const gdl_matrix_float * A,
//                      const gdl_matrix_float * B,
//                      float beta,
//                      gdl_matrix_float * C);
//
//int  gdl_blas_strmm (CBLAS_SIDE_t Side,
//                     CBLAS_UPLO_t Uplo, CBLAS_TRANSPOSE_t TransA,
//                     CBLAS_DIAG_t Diag,
//                     float alpha,
//                     const gdl_matrix_float * A,
//                     gdl_matrix_float * B);
//
//int  gdl_blas_strsm (CBLAS_SIDE_t Side,
//                     CBLAS_UPLO_t Uplo, CBLAS_TRANSPOSE_t TransA,
//                     CBLAS_DIAG_t Diag,
//                     float alpha,
//                     const gdl_matrix_float * A,
//                     gdl_matrix_float * B);

int  gdl_blas_dgemm (CBLAS_TRANSPOSE_t TransA,
                     CBLAS_TRANSPOSE_t TransB,
                     double alpha,
                     const gdl_matrix * A,
                     const gdl_matrix * B,
                     double beta,
                     gdl_matrix * C);

int  gdl_blas_dsymm (CBLAS_SIDE_t Side,
                     CBLAS_UPLO_t Uplo,
                     double alpha,
                     const gdl_matrix * A,
                     const gdl_matrix * B,
                     double beta,
                     gdl_matrix * C);

int  gdl_blas_dsyrk (CBLAS_UPLO_t Uplo,
                     CBLAS_TRANSPOSE_t Trans,
                     double alpha,
                     const gdl_matrix * A,
                     double beta,
                     gdl_matrix * C);

int  gdl_blas_dsyr2k (CBLAS_UPLO_t Uplo,
                      CBLAS_TRANSPOSE_t Trans,
                      double alpha,
                      const  gdl_matrix * A,
                      const  gdl_matrix * B,
                      double beta,
                      gdl_matrix * C);

int  gdl_blas_dtrmm (CBLAS_SIDE_t Side,
                     CBLAS_UPLO_t Uplo, CBLAS_TRANSPOSE_t TransA,
                     CBLAS_DIAG_t Diag,
                     double alpha,
                     const gdl_matrix * A,
                     gdl_matrix * B);

int  gdl_blas_dtrsm (CBLAS_SIDE_t Side,
                     CBLAS_UPLO_t Uplo, CBLAS_TRANSPOSE_t TransA,
                     CBLAS_DIAG_t Diag,
                     double alpha,
                     const gdl_matrix * A,
                     gdl_matrix * B);

//int  gdl_blas_cgemm (CBLAS_TRANSPOSE_t TransA,
//                     CBLAS_TRANSPOSE_t TransB,
//                     const gdl_complex_float alpha,
//                     const gdl_matrix_complex_float * A,
//                     const gdl_matrix_complex_float * B,
//                     const gdl_complex_float beta,
//                     gdl_matrix_complex_float * C);
//
//int  gdl_blas_csymm (CBLAS_SIDE_t Side,
//                     CBLAS_UPLO_t Uplo,
//                     const gdl_complex_float alpha,
//                     const gdl_matrix_complex_float * A,
//                     const gdl_matrix_complex_float * B,
//                     const gdl_complex_float beta,
//                     gdl_matrix_complex_float * C);
//
//int  gdl_blas_csyrk (CBLAS_UPLO_t Uplo,
//                     CBLAS_TRANSPOSE_t Trans,
//                     const gdl_complex_float alpha,
//                     const gdl_matrix_complex_float * A,
//                     const gdl_complex_float beta,
//                     gdl_matrix_complex_float * C);
//
//int  gdl_blas_csyr2k (CBLAS_UPLO_t Uplo,
//                      CBLAS_TRANSPOSE_t Trans,
//                      const gdl_complex_float alpha,
//                      const gdl_matrix_complex_float * A,
//                      const gdl_matrix_complex_float * B,
//                      const gdl_complex_float beta,
//                      gdl_matrix_complex_float * C);
//
//int  gdl_blas_ctrmm (CBLAS_SIDE_t Side,
//                     CBLAS_UPLO_t Uplo, CBLAS_TRANSPOSE_t TransA,
//                     CBLAS_DIAG_t Diag,
//                     const gdl_complex_float alpha,
//                     const gdl_matrix_complex_float * A,
//                     gdl_matrix_complex_float * B);
//
//int  gdl_blas_ctrsm (CBLAS_SIDE_t Side,
//                     CBLAS_UPLO_t Uplo, CBLAS_TRANSPOSE_t TransA,
//                     CBLAS_DIAG_t Diag,
//                     const gdl_complex_float alpha,
//                     const gdl_matrix_complex_float * A,
//                     gdl_matrix_complex_float * B);
//
//int  gdl_blas_zgemm (CBLAS_TRANSPOSE_t TransA,
//                     CBLAS_TRANSPOSE_t TransB,
//                     const gdl_complex alpha,
//                     const gdl_matrix_complex * A,
//                     const gdl_matrix_complex * B,
//                     const gdl_complex beta,
//                     gdl_matrix_complex * C);
//
//int  gdl_blas_zsymm (CBLAS_SIDE_t Side,
//                     CBLAS_UPLO_t Uplo,
//                     const gdl_complex alpha,
//                     const gdl_matrix_complex * A,
//                     const gdl_matrix_complex * B,
//                     const gdl_complex beta,
//                     gdl_matrix_complex * C);
//
//int  gdl_blas_zsyrk (CBLAS_UPLO_t Uplo,
//                     CBLAS_TRANSPOSE_t Trans,
//                     const gdl_complex alpha,
//                     const gdl_matrix_complex * A,
//                     const gdl_complex beta,
//                     gdl_matrix_complex * C);
//
//int  gdl_blas_zsyr2k (CBLAS_UPLO_t Uplo,
//                      CBLAS_TRANSPOSE_t Trans,
//                      const gdl_complex alpha,
//                      const gdl_matrix_complex * A,
//                      const gdl_matrix_complex * B,
//                      const gdl_complex beta,
//                      gdl_matrix_complex *C);
//
//int  gdl_blas_ztrmm (CBLAS_SIDE_t Side,
//                     CBLAS_UPLO_t Uplo, CBLAS_TRANSPOSE_t TransA,
//                     CBLAS_DIAG_t Diag,
//                     const gdl_complex alpha,
//                     const gdl_matrix_complex * A,
//                     gdl_matrix_complex * B);
//
//int  gdl_blas_ztrsm (CBLAS_SIDE_t Side,
//                     CBLAS_UPLO_t Uplo, CBLAS_TRANSPOSE_t TransA,
//                     CBLAS_DIAG_t Diag,
//                     const gdl_complex alpha,
//                     const gdl_matrix_complex * A,
//                     gdl_matrix_complex * B);

/*
 * Routines with prefixes C and Z only
 */
//int  gdl_blas_chemm (CBLAS_SIDE_t Side,
//                     CBLAS_UPLO_t Uplo,
//                     const gdl_complex_float alpha,
//                     const gdl_matrix_complex_float * A,
//                     const gdl_matrix_complex_float * B,
//                     const gdl_complex_float beta,
//                     gdl_matrix_complex_float * C);
//
//int  gdl_blas_cherk (CBLAS_UPLO_t Uplo,
//                     CBLAS_TRANSPOSE_t Trans,
//                     float alpha,
//                     const gdl_matrix_complex_float * A,
//                     float beta,
//                     gdl_matrix_complex_float * C);
//
//int  gdl_blas_cher2k (CBLAS_UPLO_t Uplo,
//                      CBLAS_TRANSPOSE_t Trans,
//                      const gdl_complex_float alpha,
//                      const gdl_matrix_complex_float * A,
//                      const gdl_matrix_complex_float * B,
//                      float beta,
//                      gdl_matrix_complex_float * C);
//
//int  gdl_blas_zhemm (CBLAS_SIDE_t Side,
//                     CBLAS_UPLO_t Uplo,
//                     const gdl_complex alpha,
//                     const gdl_matrix_complex * A,
//                     const gdl_matrix_complex * B,
//                     const gdl_complex beta,
//                     gdl_matrix_complex * C);
//
//int  gdl_blas_zherk (CBLAS_UPLO_t Uplo,
//                     CBLAS_TRANSPOSE_t Trans,
//                     double alpha,
//                     const gdl_matrix_complex * A,
//                     double beta,
//                     gdl_matrix_complex * C);
//
//int  gdl_blas_zher2k (CBLAS_UPLO_t Uplo,
//                      CBLAS_TRANSPOSE_t Trans,
//                      const gdl_complex alpha,
//                      const gdl_matrix_complex * A,
//                      const gdl_matrix_complex * B,
//                      double beta,
//                      gdl_matrix_complex * C);


__END_DECLS

#endif /* __GDL_BLAS_H__ */
