#include <gdl/gdl_test.h>
#include <gdl/gdl_math.h>
#include <gdl/gdl_cblas.h>

#include "tests.h"

void
test_rotg (void) {
const double flteps = 1e-4, dbleps = 1e-6;
  {
   float a = -1.5f;
   float b = -1.5f;
   float c;
   float s;
   float r_expected = -2.12132034356f;
   float z_expected = 1.41421356237f;
   float c_expected = 0.707106781187f;
   float s_expected = 0.707106781187f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 166)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 167)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 168)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 169)");
  };


  {
   float a = -1.5f;
   float b = -1.0f;
   float c;
   float s;
   float r_expected = -1.80277563773f;
   float z_expected = 0.554700196225f;
   float c_expected = 0.832050294338f;
   float s_expected = 0.554700196225f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 170)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 171)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 172)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 173)");
  };


  {
   float a = -1.5f;
   float b = -0.1f;
   float c;
   float s;
   float r_expected = -1.50332963784f;
   float z_expected = 0.0665190105238f;
   float c_expected = 0.997785157857f;
   float s_expected = 0.0665190105238f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 174)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 175)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 176)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 177)");
  };


  {
   float a = -1.5f;
   float b = 0.0f;
   float c;
   float s;
   float r_expected = -1.5f;
   float z_expected = -0.0f;
   float c_expected = 1.0f;
   float s_expected = -0.0f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 178)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 179)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 180)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 181)");
  };


  {
   float a = -1.5f;
   float b = 0.1f;
   float c;
   float s;
   float r_expected = -1.50332963784f;
   float z_expected = -0.0665190105238f;
   float c_expected = 0.997785157857f;
   float s_expected = -0.0665190105238f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 182)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 183)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 184)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 185)");
  };


  {
   float a = -1.5f;
   float b = 1.0f;
   float c;
   float s;
   float r_expected = -1.80277563773f;
   float z_expected = -0.554700196225f;
   float c_expected = 0.832050294338f;
   float s_expected = -0.554700196225f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 186)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 187)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 188)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 189)");
  };


  {
   float a = -1.5f;
   float b = 1.5f;
   float c;
   float s;
   float r_expected = 2.12132034356f;
   float z_expected = -1.41421356237f;
   float c_expected = -0.707106781187f;
   float s_expected = 0.707106781187f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 190)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 191)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 192)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 193)");
  };


  {
   float a = -1.0f;
   float b = -1.5f;
   float c;
   float s;
   float r_expected = -1.80277563773f;
   float z_expected = 1.80277563773f;
   float c_expected = 0.554700196225f;
   float s_expected = 0.832050294338f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 194)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 195)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 196)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 197)");
  };


  {
   float a = -1.0f;
   float b = -1.0f;
   float c;
   float s;
   float r_expected = -1.41421356237f;
   float z_expected = 1.41421356237f;
   float c_expected = 0.707106781187f;
   float s_expected = 0.707106781187f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 198)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 199)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 200)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 201)");
  };


  {
   float a = -1.0f;
   float b = -0.1f;
   float c;
   float s;
   float r_expected = -1.00498756211f;
   float z_expected = 0.099503719021f;
   float c_expected = 0.99503719021f;
   float s_expected = 0.099503719021f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 202)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 203)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 204)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 205)");
  };


  {
   float a = -1.0f;
   float b = 0.0f;
   float c;
   float s;
   float r_expected = -1.0f;
   float z_expected = -0.0f;
   float c_expected = 1.0f;
   float s_expected = -0.0f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 206)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 207)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 208)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 209)");
  };


  {
   float a = -1.0f;
   float b = 0.1f;
   float c;
   float s;
   float r_expected = -1.00498756211f;
   float z_expected = -0.099503719021f;
   float c_expected = 0.99503719021f;
   float s_expected = -0.099503719021f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 210)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 211)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 212)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 213)");
  };


  {
   float a = -1.0f;
   float b = 1.0f;
   float c;
   float s;
   float r_expected = 1.41421356237f;
   float z_expected = -1.41421356237f;
   float c_expected = -0.707106781187f;
   float s_expected = 0.707106781187f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 214)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 215)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 216)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 217)");
  };


  {
   float a = -1.0f;
   float b = 1.5f;
   float c;
   float s;
   float r_expected = 1.80277563773f;
   float z_expected = -1.80277563773f;
   float c_expected = -0.554700196225f;
   float s_expected = 0.832050294338f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 218)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 219)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 220)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 221)");
  };


  {
   float a = -0.1f;
   float b = -1.5f;
   float c;
   float s;
   float r_expected = -1.50332963784f;
   float z_expected = 15.0332963784f;
   float c_expected = 0.0665190105238f;
   float s_expected = 0.997785157857f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 222)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 223)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 224)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 225)");
  };


  {
   float a = -0.1f;
   float b = -1.0f;
   float c;
   float s;
   float r_expected = -1.00498756211f;
   float z_expected = 10.0498756211f;
   float c_expected = 0.099503719021f;
   float s_expected = 0.99503719021f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 226)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 227)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 228)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 229)");
  };


  {
   float a = -0.1f;
   float b = -0.1f;
   float c;
   float s;
   float r_expected = -0.141421356237f;
   float z_expected = 1.41421356237f;
   float c_expected = 0.707106781187f;
   float s_expected = 0.707106781187f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 230)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 231)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 232)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 233)");
  };


  {
   float a = -0.1f;
   float b = 0.0f;
   float c;
   float s;
   float r_expected = -0.1f;
   float z_expected = -0.0f;
   float c_expected = 1.0f;
   float s_expected = -0.0f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 234)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 235)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 236)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 237)");
  };


  {
   float a = -0.1f;
   float b = 0.1f;
   float c;
   float s;
   float r_expected = 0.141421356237f;
   float z_expected = -1.41421356237f;
   float c_expected = -0.707106781187f;
   float s_expected = 0.707106781187f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 238)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 239)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 240)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 241)");
  };


  {
   float a = -0.1f;
   float b = 1.0f;
   float c;
   float s;
   float r_expected = 1.00498756211f;
   float z_expected = -10.0498756211f;
   float c_expected = -0.099503719021f;
   float s_expected = 0.99503719021f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 242)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 243)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 244)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 245)");
  };


  {
   float a = -0.1f;
   float b = 1.5f;
   float c;
   float s;
   float r_expected = 1.50332963784f;
   float z_expected = -15.0332963784f;
   float c_expected = -0.0665190105238f;
   float s_expected = 0.997785157857f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 246)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 247)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 248)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 249)");
  };


  {
   float a = 0.0f;
   float b = -1.5f;
   float c;
   float s;
   float r_expected = -1.5f;
   float z_expected = 1.0f;
   float c_expected = -0.0f;
   float s_expected = 1.0f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 250)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 251)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 252)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 253)");
  };


  {
   float a = 0.0f;
   float b = -1.0f;
   float c;
   float s;
   float r_expected = -1.0f;
   float z_expected = 1.0f;
   float c_expected = -0.0f;
   float s_expected = 1.0f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 254)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 255)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 256)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 257)");
  };


  {
   float a = 0.0f;
   float b = -0.1f;
   float c;
   float s;
   float r_expected = -0.1f;
   float z_expected = 1.0f;
   float c_expected = -0.0f;
   float s_expected = 1.0f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 258)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 259)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 260)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 261)");
  };


  {
   float a = 0.0f;
   float b = 0.0f;
   float c;
   float s;
   float r_expected = 0.0f;
   float z_expected = 0.0f;
   float c_expected = 1.0f;
   float s_expected = 0.0f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 262)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 263)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 264)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 265)");
  };


  {
   float a = 0.0f;
   float b = 0.1f;
   float c;
   float s;
   float r_expected = 0.1f;
   float z_expected = 1.0f;
   float c_expected = 0.0f;
   float s_expected = 1.0f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 266)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 267)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 268)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 269)");
  };


  {
   float a = 0.0f;
   float b = 1.0f;
   float c;
   float s;
   float r_expected = 1.0f;
   float z_expected = 1.0f;
   float c_expected = 0.0f;
   float s_expected = 1.0f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 270)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 271)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 272)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 273)");
  };


  {
   float a = 0.0f;
   float b = 1.5f;
   float c;
   float s;
   float r_expected = 1.5f;
   float z_expected = 1.0f;
   float c_expected = 0.0f;
   float s_expected = 1.0f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 274)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 275)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 276)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 277)");
  };


  {
   float a = 0.1f;
   float b = -1.5f;
   float c;
   float s;
   float r_expected = -1.50332963784f;
   float z_expected = -15.0332963784f;
   float c_expected = -0.0665190105238f;
   float s_expected = 0.997785157857f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 278)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 279)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 280)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 281)");
  };


  {
   float a = 0.1f;
   float b = -1.0f;
   float c;
   float s;
   float r_expected = -1.00498756211f;
   float z_expected = -10.0498756211f;
   float c_expected = -0.099503719021f;
   float s_expected = 0.99503719021f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 282)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 283)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 284)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 285)");
  };


  {
   float a = 0.1f;
   float b = -0.1f;
   float c;
   float s;
   float r_expected = -0.141421356237f;
   float z_expected = -1.41421356237f;
   float c_expected = -0.707106781187f;
   float s_expected = 0.707106781187f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 286)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 287)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 288)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 289)");
  };


  {
   float a = 0.1f;
   float b = 0.0f;
   float c;
   float s;
   float r_expected = 0.1f;
   float z_expected = 0.0f;
   float c_expected = 1.0f;
   float s_expected = 0.0f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 290)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 291)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 292)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 293)");
  };


  {
   float a = 0.1f;
   float b = 0.1f;
   float c;
   float s;
   float r_expected = 0.141421356237f;
   float z_expected = 1.41421356237f;
   float c_expected = 0.707106781187f;
   float s_expected = 0.707106781187f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 294)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 295)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 296)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 297)");
  };


  {
   float a = 0.1f;
   float b = 1.0f;
   float c;
   float s;
   float r_expected = 1.00498756211f;
   float z_expected = 10.0498756211f;
   float c_expected = 0.099503719021f;
   float s_expected = 0.99503719021f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 298)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 299)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 300)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 301)");
  };


  {
   float a = 0.1f;
   float b = 1.5f;
   float c;
   float s;
   float r_expected = 1.50332963784f;
   float z_expected = 15.0332963784f;
   float c_expected = 0.0665190105238f;
   float s_expected = 0.997785157857f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 302)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 303)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 304)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 305)");
  };


  {
   float a = 1.0f;
   float b = -1.5f;
   float c;
   float s;
   float r_expected = -1.80277563773f;
   float z_expected = -1.80277563773f;
   float c_expected = -0.554700196225f;
   float s_expected = 0.832050294338f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 306)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 307)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 308)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 309)");
  };


  {
   float a = 1.0f;
   float b = -1.0f;
   float c;
   float s;
   float r_expected = -1.41421356237f;
   float z_expected = -1.41421356237f;
   float c_expected = -0.707106781187f;
   float s_expected = 0.707106781187f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 310)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 311)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 312)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 313)");
  };


  {
   float a = 1.0f;
   float b = -0.1f;
   float c;
   float s;
   float r_expected = 1.00498756211f;
   float z_expected = -0.099503719021f;
   float c_expected = 0.99503719021f;
   float s_expected = -0.099503719021f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 314)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 315)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 316)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 317)");
  };


  {
   float a = 1.0f;
   float b = 0.0f;
   float c;
   float s;
   float r_expected = 1.0f;
   float z_expected = 0.0f;
   float c_expected = 1.0f;
   float s_expected = 0.0f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 318)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 319)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 320)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 321)");
  };


  {
   float a = 1.0f;
   float b = 0.1f;
   float c;
   float s;
   float r_expected = 1.00498756211f;
   float z_expected = 0.099503719021f;
   float c_expected = 0.99503719021f;
   float s_expected = 0.099503719021f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 322)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 323)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 324)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 325)");
  };


  {
   float a = 1.0f;
   float b = 1.0f;
   float c;
   float s;
   float r_expected = 1.41421356237f;
   float z_expected = 1.41421356237f;
   float c_expected = 0.707106781187f;
   float s_expected = 0.707106781187f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 326)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 327)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 328)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 329)");
  };


  {
   float a = 1.0f;
   float b = 1.5f;
   float c;
   float s;
   float r_expected = 1.80277563773f;
   float z_expected = 1.80277563773f;
   float c_expected = 0.554700196225f;
   float s_expected = 0.832050294338f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 330)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 331)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 332)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 333)");
  };


  {
   float a = 1.5f;
   float b = -1.5f;
   float c;
   float s;
   float r_expected = -2.12132034356f;
   float z_expected = -1.41421356237f;
   float c_expected = -0.707106781187f;
   float s_expected = 0.707106781187f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 334)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 335)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 336)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 337)");
  };


  {
   float a = 1.5f;
   float b = -1.0f;
   float c;
   float s;
   float r_expected = 1.80277563773f;
   float z_expected = -0.554700196225f;
   float c_expected = 0.832050294338f;
   float s_expected = -0.554700196225f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 338)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 339)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 340)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 341)");
  };


  {
   float a = 1.5f;
   float b = -0.1f;
   float c;
   float s;
   float r_expected = 1.50332963784f;
   float z_expected = -0.0665190105238f;
   float c_expected = 0.997785157857f;
   float s_expected = -0.0665190105238f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 342)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 343)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 344)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 345)");
  };


  {
   float a = 1.5f;
   float b = 0.0f;
   float c;
   float s;
   float r_expected = 1.5f;
   float z_expected = 0.0f;
   float c_expected = 1.0f;
   float s_expected = 0.0f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 346)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 347)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 348)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 349)");
  };


  {
   float a = 1.5f;
   float b = 0.1f;
   float c;
   float s;
   float r_expected = 1.50332963784f;
   float z_expected = 0.0665190105238f;
   float c_expected = 0.997785157857f;
   float s_expected = 0.0665190105238f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 350)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 351)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 352)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 353)");
  };


  {
   float a = 1.5f;
   float b = 1.0f;
   float c;
   float s;
   float r_expected = 1.80277563773f;
   float z_expected = 0.554700196225f;
   float c_expected = 0.832050294338f;
   float s_expected = 0.554700196225f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 354)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 355)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 356)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 357)");
  };


  {
   float a = 1.5f;
   float b = 1.5f;
   float c;
   float s;
   float r_expected = 2.12132034356f;
   float z_expected = 1.41421356237f;
   float c_expected = 0.707106781187f;
   float s_expected = 0.707106781187f;
   cblas_srotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, flteps, "srotg(case 358)");
   gdl_test_rel(b, z_expected, flteps, "srotg(case 359)");
   gdl_test_rel(c, c_expected, flteps, "srotg(case 360)");
   gdl_test_rel(s, s_expected, flteps, "srotg(case 361)");
  };


  {
   double a = -1.5;
   double b = -1.5;
   double c;
   double s;
   double r_expected = -2.12132034356;
   double z_expected = 1.41421356237;
   double c_expected = 0.707106781187;
   double s_expected = 0.707106781187;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 362)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 363)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 364)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 365)");
  };


  {
   double a = -1.5;
   double b = -1;
   double c;
   double s;
   double r_expected = -1.80277563773;
   double z_expected = 0.554700196225;
   double c_expected = 0.832050294338;
   double s_expected = 0.554700196225;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 366)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 367)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 368)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 369)");
  };


  {
   double a = -1.5;
   double b = -0.1;
   double c;
   double s;
   double r_expected = -1.50332963784;
   double z_expected = 0.0665190105238;
   double c_expected = 0.997785157857;
   double s_expected = 0.0665190105238;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 370)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 371)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 372)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 373)");
  };


  {
   double a = -1.5;
   double b = 0;
   double c;
   double s;
   double r_expected = -1.5;
   double z_expected = -0;
   double c_expected = 1;
   double s_expected = -0;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 374)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 375)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 376)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 377)");
  };


  {
   double a = -1.5;
   double b = 0.1;
   double c;
   double s;
   double r_expected = -1.50332963784;
   double z_expected = -0.0665190105238;
   double c_expected = 0.997785157857;
   double s_expected = -0.0665190105238;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 378)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 379)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 380)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 381)");
  };


  {
   double a = -1.5;
   double b = 1;
   double c;
   double s;
   double r_expected = -1.80277563773;
   double z_expected = -0.554700196225;
   double c_expected = 0.832050294338;
   double s_expected = -0.554700196225;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 382)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 383)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 384)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 385)");
  };


  {
   double a = -1.5;
   double b = 1.5;
   double c;
   double s;
   double r_expected = 2.12132034356;
   double z_expected = -1.41421356237;
   double c_expected = -0.707106781187;
   double s_expected = 0.707106781187;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 386)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 387)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 388)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 389)");
  };


  {
   double a = -1;
   double b = -1.5;
   double c;
   double s;
   double r_expected = -1.80277563773;
   double z_expected = 1.80277563773;
   double c_expected = 0.554700196225;
   double s_expected = 0.832050294338;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 390)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 391)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 392)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 393)");
  };


  {
   double a = -1;
   double b = -1;
   double c;
   double s;
   double r_expected = -1.41421356237;
   double z_expected = 1.41421356237;
   double c_expected = 0.707106781187;
   double s_expected = 0.707106781187;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 394)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 395)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 396)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 397)");
  };


  {
   double a = -1;
   double b = -0.1;
   double c;
   double s;
   double r_expected = -1.00498756211;
   double z_expected = 0.099503719021;
   double c_expected = 0.99503719021;
   double s_expected = 0.099503719021;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 398)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 399)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 400)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 401)");
  };


  {
   double a = -1;
   double b = 0;
   double c;
   double s;
   double r_expected = -1;
   double z_expected = -0;
   double c_expected = 1;
   double s_expected = -0;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 402)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 403)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 404)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 405)");
  };


  {
   double a = -1;
   double b = 0.1;
   double c;
   double s;
   double r_expected = -1.00498756211;
   double z_expected = -0.099503719021;
   double c_expected = 0.99503719021;
   double s_expected = -0.099503719021;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 406)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 407)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 408)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 409)");
  };


  {
   double a = -1;
   double b = 1;
   double c;
   double s;
   double r_expected = 1.41421356237;
   double z_expected = -1.41421356237;
   double c_expected = -0.707106781187;
   double s_expected = 0.707106781187;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 410)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 411)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 412)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 413)");
  };


  {
   double a = -1;
   double b = 1.5;
   double c;
   double s;
   double r_expected = 1.80277563773;
   double z_expected = -1.80277563773;
   double c_expected = -0.554700196225;
   double s_expected = 0.832050294338;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 414)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 415)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 416)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 417)");
  };


  {
   double a = -0.1;
   double b = -1.5;
   double c;
   double s;
   double r_expected = -1.50332963784;
   double z_expected = 15.0332963784;
   double c_expected = 0.0665190105238;
   double s_expected = 0.997785157857;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 418)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 419)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 420)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 421)");
  };


  {
   double a = -0.1;
   double b = -1;
   double c;
   double s;
   double r_expected = -1.00498756211;
   double z_expected = 10.0498756211;
   double c_expected = 0.099503719021;
   double s_expected = 0.99503719021;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 422)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 423)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 424)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 425)");
  };


  {
   double a = -0.1;
   double b = -0.1;
   double c;
   double s;
   double r_expected = -0.141421356237;
   double z_expected = 1.41421356237;
   double c_expected = 0.707106781187;
   double s_expected = 0.707106781187;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 426)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 427)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 428)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 429)");
  };


  {
   double a = -0.1;
   double b = 0;
   double c;
   double s;
   double r_expected = -0.1;
   double z_expected = -0;
   double c_expected = 1;
   double s_expected = -0;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 430)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 431)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 432)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 433)");
  };


  {
   double a = -0.1;
   double b = 0.1;
   double c;
   double s;
   double r_expected = 0.141421356237;
   double z_expected = -1.41421356237;
   double c_expected = -0.707106781187;
   double s_expected = 0.707106781187;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 434)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 435)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 436)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 437)");
  };


  {
   double a = -0.1;
   double b = 1;
   double c;
   double s;
   double r_expected = 1.00498756211;
   double z_expected = -10.0498756211;
   double c_expected = -0.099503719021;
   double s_expected = 0.99503719021;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 438)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 439)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 440)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 441)");
  };


  {
   double a = -0.1;
   double b = 1.5;
   double c;
   double s;
   double r_expected = 1.50332963784;
   double z_expected = -15.0332963784;
   double c_expected = -0.0665190105238;
   double s_expected = 0.997785157857;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 442)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 443)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 444)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 445)");
  };


  {
   double a = 0;
   double b = -1.5;
   double c;
   double s;
   double r_expected = -1.5;
   double z_expected = 1;
   double c_expected = -0;
   double s_expected = 1;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 446)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 447)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 448)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 449)");
  };


  {
   double a = 0;
   double b = -1;
   double c;
   double s;
   double r_expected = -1;
   double z_expected = 1;
   double c_expected = -0;
   double s_expected = 1;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 450)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 451)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 452)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 453)");
  };


  {
   double a = 0;
   double b = -0.1;
   double c;
   double s;
   double r_expected = -0.1;
   double z_expected = 1;
   double c_expected = -0;
   double s_expected = 1;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 454)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 455)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 456)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 457)");
  };


  {
   double a = 0;
   double b = 0;
   double c;
   double s;
   double r_expected = 0;
   double z_expected = 0;
   double c_expected = 1;
   double s_expected = 0;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 458)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 459)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 460)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 461)");
  };


  {
   double a = 0;
   double b = 0.1;
   double c;
   double s;
   double r_expected = 0.1;
   double z_expected = 1;
   double c_expected = 0;
   double s_expected = 1;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 462)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 463)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 464)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 465)");
  };


  {
   double a = 0;
   double b = 1;
   double c;
   double s;
   double r_expected = 1;
   double z_expected = 1;
   double c_expected = 0;
   double s_expected = 1;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 466)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 467)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 468)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 469)");
  };


  {
   double a = 0;
   double b = 1.5;
   double c;
   double s;
   double r_expected = 1.5;
   double z_expected = 1;
   double c_expected = 0;
   double s_expected = 1;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 470)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 471)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 472)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 473)");
  };


  {
   double a = 0.1;
   double b = -1.5;
   double c;
   double s;
   double r_expected = -1.50332963784;
   double z_expected = -15.0332963784;
   double c_expected = -0.0665190105238;
   double s_expected = 0.997785157857;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 474)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 475)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 476)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 477)");
  };


  {
   double a = 0.1;
   double b = -1;
   double c;
   double s;
   double r_expected = -1.00498756211;
   double z_expected = -10.0498756211;
   double c_expected = -0.099503719021;
   double s_expected = 0.99503719021;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 478)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 479)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 480)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 481)");
  };


  {
   double a = 0.1;
   double b = -0.1;
   double c;
   double s;
   double r_expected = -0.141421356237;
   double z_expected = -1.41421356237;
   double c_expected = -0.707106781187;
   double s_expected = 0.707106781187;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 482)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 483)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 484)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 485)");
  };


  {
   double a = 0.1;
   double b = 0;
   double c;
   double s;
   double r_expected = 0.1;
   double z_expected = 0;
   double c_expected = 1;
   double s_expected = 0;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 486)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 487)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 488)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 489)");
  };


  {
   double a = 0.1;
   double b = 0.1;
   double c;
   double s;
   double r_expected = 0.141421356237;
   double z_expected = 1.41421356237;
   double c_expected = 0.707106781187;
   double s_expected = 0.707106781187;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 490)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 491)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 492)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 493)");
  };


  {
   double a = 0.1;
   double b = 1;
   double c;
   double s;
   double r_expected = 1.00498756211;
   double z_expected = 10.0498756211;
   double c_expected = 0.099503719021;
   double s_expected = 0.99503719021;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 494)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 495)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 496)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 497)");
  };


  {
   double a = 0.1;
   double b = 1.5;
   double c;
   double s;
   double r_expected = 1.50332963784;
   double z_expected = 15.0332963784;
   double c_expected = 0.0665190105238;
   double s_expected = 0.997785157857;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 498)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 499)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 500)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 501)");
  };


  {
   double a = 1;
   double b = -1.5;
   double c;
   double s;
   double r_expected = -1.80277563773;
   double z_expected = -1.80277563773;
   double c_expected = -0.554700196225;
   double s_expected = 0.832050294338;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 502)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 503)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 504)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 505)");
  };


  {
   double a = 1;
   double b = -1;
   double c;
   double s;
   double r_expected = -1.41421356237;
   double z_expected = -1.41421356237;
   double c_expected = -0.707106781187;
   double s_expected = 0.707106781187;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 506)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 507)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 508)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 509)");
  };


  {
   double a = 1;
   double b = -0.1;
   double c;
   double s;
   double r_expected = 1.00498756211;
   double z_expected = -0.099503719021;
   double c_expected = 0.99503719021;
   double s_expected = -0.099503719021;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 510)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 511)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 512)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 513)");
  };


  {
   double a = 1;
   double b = 0;
   double c;
   double s;
   double r_expected = 1;
   double z_expected = 0;
   double c_expected = 1;
   double s_expected = 0;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 514)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 515)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 516)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 517)");
  };


  {
   double a = 1;
   double b = 0.1;
   double c;
   double s;
   double r_expected = 1.00498756211;
   double z_expected = 0.099503719021;
   double c_expected = 0.99503719021;
   double s_expected = 0.099503719021;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 518)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 519)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 520)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 521)");
  };


  {
   double a = 1;
   double b = 1;
   double c;
   double s;
   double r_expected = 1.41421356237;
   double z_expected = 1.41421356237;
   double c_expected = 0.707106781187;
   double s_expected = 0.707106781187;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 522)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 523)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 524)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 525)");
  };


  {
   double a = 1;
   double b = 1.5;
   double c;
   double s;
   double r_expected = 1.80277563773;
   double z_expected = 1.80277563773;
   double c_expected = 0.554700196225;
   double s_expected = 0.832050294338;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 526)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 527)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 528)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 529)");
  };


  {
   double a = 1.5;
   double b = -1.5;
   double c;
   double s;
   double r_expected = -2.12132034356;
   double z_expected = -1.41421356237;
   double c_expected = -0.707106781187;
   double s_expected = 0.707106781187;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 530)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 531)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 532)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 533)");
  };


  {
   double a = 1.5;
   double b = -1;
   double c;
   double s;
   double r_expected = 1.80277563773;
   double z_expected = -0.554700196225;
   double c_expected = 0.832050294338;
   double s_expected = -0.554700196225;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 534)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 535)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 536)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 537)");
  };


  {
   double a = 1.5;
   double b = -0.1;
   double c;
   double s;
   double r_expected = 1.50332963784;
   double z_expected = -0.0665190105238;
   double c_expected = 0.997785157857;
   double s_expected = -0.0665190105238;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 538)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 539)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 540)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 541)");
  };


  {
   double a = 1.5;
   double b = 0;
   double c;
   double s;
   double r_expected = 1.5;
   double z_expected = 0;
   double c_expected = 1;
   double s_expected = 0;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 542)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 543)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 544)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 545)");
  };


  {
   double a = 1.5;
   double b = 0.1;
   double c;
   double s;
   double r_expected = 1.50332963784;
   double z_expected = 0.0665190105238;
   double c_expected = 0.997785157857;
   double s_expected = 0.0665190105238;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 546)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 547)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 548)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 549)");
  };


  {
   double a = 1.5;
   double b = 1;
   double c;
   double s;
   double r_expected = 1.80277563773;
   double z_expected = 0.554700196225;
   double c_expected = 0.832050294338;
   double s_expected = 0.554700196225;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 550)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 551)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 552)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 553)");
  };


  {
   double a = 1.5;
   double b = 1.5;
   double c;
   double s;
   double r_expected = 2.12132034356;
   double z_expected = 1.41421356237;
   double c_expected = 0.707106781187;
   double s_expected = 0.707106781187;
   cblas_drotg(&a, &b, &c, &s);
   gdl_test_rel(a, r_expected, dbleps, "drotg(case 554)");
   gdl_test_rel(b, z_expected, dbleps, "drotg(case 555)");
   gdl_test_rel(c, c_expected, dbleps, "drotg(case 556)");
   gdl_test_rel(s, s_expected, dbleps, "drotg(case 557)");
  };


}
