/*  
 * 	clust/fread.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_sort_uint.h>
#include <gdl/gdl_clustering.h>

gdl_clustering *
gdl_clustering_fread (FILE * stream)
{
	if (stream)
	{
		size_t i;
		int status;
		gdl_clustering * c = GDL_MALLOC (gdl_clustering, 1);
		
		status = fread (&c->ne, sizeof (size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&c->nc, sizeof (size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		
		c->cidx = GDL_MALLOC (size_t, c->ne);
		c->ridx = GDL_MALLOC (size_t, c->nc);
		c->nbc  = GDL_MALLOC (size_t, c->nc);
		c->clusters = GDL_CALLOC (size_t *, c->nc);
		
		status = fread (c->nbc, sizeof (size_t), c->nc, stream);
		GDL_FREAD_STATUS (status, c->nc);
		
		for (i = 0; i < c->nc; i++)
		{
			gdl_boolean has;
			status = fread (&has, sizeof (gdl_boolean), 1, stream);
			GDL_FREAD_STATUS (status, 1);
			if (has)
			{
				c->clusters[i] = GDL_MALLOC (size_t, c->nbc[i]);
				status = fread (c->clusters[i], sizeof (size_t), c->nbc[i], stream);
				GDL_FREAD_STATUS (status, c->nbc[i]);
			}
		}
		status = fread (c->ridx, sizeof (size_t), c->nc, stream);
		GDL_FREAD_STATUS (status, c->nc);
		status = fread (c->cidx, sizeof (size_t), c->ne, stream);
		GDL_FREAD_STATUS (status, c->ne);
		
		return c;
	}
	else
	{
		return NULL;	
	}
}

int
gdl_clustering_fwrite (FILE * stream, const gdl_clustering * c)
{
	if (stream && c)
	{
		size_t i;
		int status;
		
		status = fwrite (&c->ne, sizeof (size_t), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (&c->nc, sizeof (size_t), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (c->nbc, sizeof (size_t), c->nc, stream);
		GDL_FWRITE_STATUS (status, c->nc);
		for (i = 0; i < c->nc; i++)
		{
			gdl_boolean has = (c->clusters[i]) ? gdl_true : gdl_false;
			status = fwrite (&has, sizeof (gdl_boolean), 1, stream);
			GDL_FWRITE_STATUS (status, 1);
			if (has)
			{
				status = fwrite (c->clusters[i], sizeof (size_t), c->nbc[i], stream);
				GDL_FWRITE_STATUS (status, c->nbc[i]);
			}
		}
		status = fwrite (c->ridx, sizeof (size_t), c->nc, stream);
		GDL_FWRITE_STATUS (status, c->nc);
		status = fwrite (c->cidx, sizeof (size_t), c->ne, stream);
		GDL_FWRITE_STATUS (status, c->ne);
		
		return GDL_SUCCESS;
	}
	else
	{
		return GDL_EINVAL;	
	}	
}
