/*  
 * 	clust/gdl_clustering.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
 
#ifndef __GDL_CLUSTERING_H__
#define __GDL_CLUSTERING_H__

__BEGIN_DECLS

struct _gdl_clustering_workspace
{
	size_t size;
	size_t * cidx;	
};

typedef struct _gdl_clustering_workspace gdl_clustering_workspace;
typedef struct _gdl_clustering gdl_clustering;

typedef gdl_clustering * gdl_clustering_ptr;

gdl_clustering_workspace * gdl_clustering_workspace_alloc (size_t size);
void gdl_clustering_workspace_free (gdl_clustering_workspace * c);
int gdl_clustering_workspace_set (gdl_clustering_workspace * c, size_t i, size_t j);

gdl_clustering * gdl_clustering_workspace_done (gdl_clustering_workspace * c);
gdl_clustering * gdl_clustering_clone (const gdl_clustering * c);
void gdl_clustering_free (gdl_clustering * c);

gdl_clustering * gdl_clustering_fread (FILE * stream);
int gdl_clustering_fwrite (FILE * stream, const gdl_clustering * c);

size_t gdl_clustering_size (const gdl_clustering * c);
size_t gdl_clustering_cluster (const gdl_clustering * c, size_t i);
size_t gdl_clustering_nclust (const gdl_clustering * c);
size_t gdl_clustering_clust_idx (const gdl_clustering * c, size_t i);
size_t gdl_clustering_clust_size (const gdl_clustering * c, size_t i);
size_t * gdl_clustering_clust_members (const gdl_clustering * c, size_t i);

__END_DECLS

#endif /* GDL_CLUSTERING */
