/*  
 * 	clust/work.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_clustering.h>

gdl_clustering_workspace *
gdl_clustering_workspace_alloc (size_t size)
{
	gdl_clustering_workspace * w;
	
	w = GDL_MALLOC (gdl_clustering_workspace, 1);
	
	w->size = size;
	
	w->cidx = GDL_CALLOC (size_t, size);
	
	return w;
}

void
gdl_clustering_workspace_free (gdl_clustering_workspace * w)
{
	if (w)
	{
		GDL_FREE (w->cidx);
		GDL_FREE (w);
	}	
}

int
gdl_clustering_workspace_set (gdl_clustering_workspace * w, size_t i, size_t j)
{
	w->cidx[j] = i + 1;
}

