/* dico/gdl_dictionary.h
 * 
 * Copyright (C) 2008 Jean-Baptiste Veyrieras
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GDL_DICTIONARY_H__
#define __GDL_DICTIONARY_H__

#include <stdlib.h>
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_hash.h>

__BEGIN_DECLS

typedef struct
{
	size_t size;
	gdl_hashtable ** entries;
	gdl_hashtable ** reverse;
	gdl_hashtable  * index;
} gdl_dictionary;

gdl_dictionary * gdl_dictionary_alloc (void);
void  gdl_dictionary_free (gdl_dictionary * d);
int gdl_dictionary_add (gdl_dictionary * d, const gdl_string * entry);
int gdl_dictionary_populate (gdl_dictionary * d, const gdl_string * entry, const gdl_string * def);
size_t gdl_dictionary_size (const gdl_dictionary * d, const gdl_string * entry);
const gdl_string * gdl_dictionary_get (const gdl_dictionary * d, const gdl_string * entry, const size_t def_idx);
const int gdl_dictionary_lookup (const gdl_dictionary * d, const gdl_string * entry, const gdl_string * def);
gdl_dictionary * gdl_dictionary_fread (FILE * stream);
int gdl_dictionary_fwrite (FILE * stream, const gdl_dictionary * d);

__END_DECLS

#endif
