/*
 *  eqtl/gdl_eqtl_chromosome.h 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:47 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_EQTL_CHROMOSOME_H__
#define __GDL_EQTL_CHROMOSOME_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_snp_chromosome.h>
#include <gdl/gdl_snp_annotation.h>
#include <gdl/gdl_genex_chromosome.h>

__BEGIN_DECLS

typedef gdl_genex_gene   gdl_eqtl_gene;
typedef gdl_genex_block  gdl_eqtl_block;
typedef gdl_genex_probe  gdl_eqtl_probe;

typedef struct
{
	gdl_string * name;
	size_t npop;
	size_t ngene;
	size_t nprobe;
	size_t nindiv;
	size_t ploidy;
	size_t * pop_sizes;
	gdl_snp_chromosome   * snp_data;
	gdl_genex_gene      ** genes;
	gdl_genex_probe     ** probes;
	FILE * logger;
	const gdl_snp_annot_dico * dico;
} gdl_eqtl_chromosome;

gdl_eqtl_chromosome * gdl_eqtl_chromosome_alloc (gdl_snp_chromosome * snp_data, gdl_genex_chromosome * exp_data);
void gdl_eqtl_chromosome_free (gdl_eqtl_chromosome * c);

void gdl_eqtl_chromosome_collapse_gene (gdl_eqtl_chromosome * c);
void gdl_eqtl_chromosome_meta_probeset (gdl_eqtl_chromosome * c, const size_t meta_type);
void gdl_eqtl_chromosome_init_window (gdl_eqtl_chromosome * chrom, gdl_snp_annot_dico * dico, const long window_size);
void gdl_eqtl_chromosome_cis_test (gdl_eqtl_chromosome * chrom, gdl_snp_annot_dico * dico, const double freqmin, const double pval, gdl_boolean max_pval);
void gdl_eqtl_chromosome_cis_permut (gdl_eqtl_chromosome * chrom, const double freqmin, const size_t permut_size, const gdl_rng * rng);

gdl_eqtl_chromosome * gdl_eqtl_chromosome_fread (FILE * stream);
int gdl_eqtl_chromosome_fwrite (FILE * stream, const gdl_eqtl_chromosome * c);

FILE * gdl_eqtl_chromosome_set_logger (gdl_eqtl_chromosome * c, FILE * stream);

void gdl_eqtl_chromosome_anchor_gene (gdl_eqtl_chromosome * chrom);

void gdl_eqtl_chromosome_get_snp_vector (gdl_eqtl_chromosome * chrom, const size_t snp, double * x, double * pop_freq, double * freq);
double ** gdl_eqtl_chromosome_cis_get_block_signal (gdl_eqtl_chromosome * chrom, gdl_eqtl_block * block, double ** var, size_t ** pidx, size_t * np);
double gdl_eqtl_chromosome_do_LRT (gdl_eqtl_chromosome * chrom, const double * x, const double * y, const double * popf, double * a, double * r2, double * p);

double gdl_eqtl_chromosome_snp_fold_change (const gdl_eqtl_chromosome * c, const gdl_eqtl_probe * probe, const size_t snp, double (*imap)(double x), size_t * rm_indiv[], size_t * ng0, size_t * ng1, size_t * ng2);
int gdl_eqtl_chromosome_get_snp_class (const gdl_eqtl_chromosome * chrom, const size_t snp_idx);

gdl_eqtl_gene * gdl_eqtl_chromosome_lookup_gene (const gdl_eqtl_chromosome * c, const gdl_string * name);
gdl_snp * gdl_eqtl_chromosome_lookup_snp (const gdl_eqtl_chromosome * c, const gdl_string * name);

int gdl_eqtl_chromosome_regadd (gdl_eqtl_chromosome * chrom, const gdl_boolean qnorm, const gdl_string * x_name, const double x[], const gdl_feature_table * gene_set, FILE * stream);

__END_DECLS

#endif
