/* err/strerror.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>

const char *
gdl_strerror (const int gdl_errno)
{
  switch (gdl_errno)
    {
    case GDL_SUCCESS:
      return "success" ;
    case GDL_FAILURE:
      return "failure" ;
    case GDL_CONTINUE:
      return "the iteration has not converged yet";
    case GDL_EDOM:
      return "input domain error" ;
    case GDL_ERANGE:
      return "output range error" ;
    case GDL_EFAULT:
      return "invalid pointer" ;
    case GDL_EINVAL:
      return "invalid argument supplied by user" ;
    case GDL_EFAILED:
      return "generic failure" ;
    case GDL_EFACTOR:
      return "factorization failed" ;
    case GDL_ESANITY:
      return "sanity check failed - shouldn't happen" ;
    case GDL_ENOMEM:
      return "malloc failed" ;
    case GDL_EBADFUNC:
      return "problem with user-supplied function";
    case GDL_ERUNAWAY:
      return "iterative process is out of control";
    case GDL_EMAXITER:
      return "exceeded max number of iterations" ;
    case GDL_EZERODIV:
      return "tried to divide by zero" ;
    case GDL_EBADTOL:
      return "specified tolerance is invalid or theoretically unattainable" ;
    case GDL_ETOL:
      return "failed to reach the specified tolerance" ;
    case GDL_EUNDRFLW:
      return "underflow" ;
    case GDL_EOVRFLW:
      return "overflow" ;
    case GDL_ELOSS:
      return "loss of accuracy" ;
    case GDL_EROUND:
      return "roundoff error" ;
    case GDL_EBADLEN:
      return "matrix/vector sizes are not conformant" ;
    case GDL_ENOTSQR:
      return "matrix not square" ;
    case GDL_ESING:
      return "singularity or extremely bad function behavior detected" ;
    case GDL_EDIVERGE:
      return "integral or series is divergent" ;
    case GDL_EUNSUP:
      return "the required feature is not supported by this hardware platform";
    case GDL_EUNIMPL:
      return "the requested feature is not (yet) implemented";
    case GDL_ECACHE:
      return "cache limit exceeded";
    case GDL_ETABLE:
      return "table limit exceeded";
    case GDL_ENOPROG:
      return "iteration is not making progress towards solution";
    case GDL_ENOPROGJ:
      return "jacobian evaluations are not improving the solution";
    case GDL_ETOLF:
      return "cannot reach the specified tolerance in F";
    case GDL_ETOLX:
      return "cannot reach the specified tolerance in X";
    case GDL_ETOLG:
      return "cannot reach the specified tolerance in gradient";
    case GDL_EOF:
      return "end of file";
    default:
      return "unknown error code" ;
    }
}
