/*  
 *  fmatrix/test.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_test.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_fview.h>
#include <gdl/gdl_fview_mask.h>
#include <gdl/gdl_fview_reader.h>
#include <gdl/gdl_fmatrix.h>

gdl_fview_reader_type *
_reader_type (size_t t)
{
	gdl_fview_reader_type * type =
    	gdl_fview_reader_type_new (gdl_fview_reader_categorial);   
}

gdl_fview *
_read_data (size_t t)
{
	size_t i, j;
	FILE * stream;
	gdl_string * file;
	gdl_fview_reader_type * type;
	gdl_fview_reader      * reader;
	gdl_fview * v;
	
	type = _reader_type (t);
	
	reader = gdl_fview_reader_alloc (type);
	
	gdl_fview_reader_open (reader, "examples/ddata.txt");
	
	v = gdl_fview_reader_parse (reader);
	
	gdl_fview_reader_close (reader);
	
	gdl_fview_reader_free (reader);
	
	return v;	
}

int
test_alloc (size_t t)
{
	size_t i, ii, j, k, ng, nc;
	gdl_fview * f;
	gdl_fmatrix * fm;
	
	f  = _read_data (t);
	
	fm = gdl_fmatrix_alloc (f, NULL, gdl_false);
	
	gdl_fmatrix_fprintf (stdout, fm);
	
	gdl_fmatrix_free (fm);
	
	gdl_fview_free (f);
	
	return GDL_SUCCESS;
}

int
main (void)
{
   test_alloc (1);	
	exit (gdl_test_summary());
}
