/*  
 *  fpoint/gdl_fpoint.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:47 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_FPOINT_H__
#define __GDL_FPOINT_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_gpoint.h>
#include <gdl/gdl_check_range.h>

__BEGIN_DECLS

typedef gdl_gvalues gdl_fdatapoint;

typedef struct _gdl_fdatapoints gdl_fdatapoints;

gdl_fdatapoints * gdl_fdatapoints_alloc (size_t n, size_t f, gdl_factor ** factors);
void gdl_fdatapoints_free (gdl_fdatapoints * g);

gdl_fdatapoints * gdl_fdatapoints_fread (FILE * stream);
int gdl_fdatapoints_fwrite (FILE * stream, const gdl_fdatapoints * g);

int gdl_fdatapoints_set (gdl_fdatapoints * g, size_t i, size_t j, const gdl_fdatapoint * x);
gdl_fdatapoint * gdl_fdatapoints_get (const gdl_fdatapoints * g, size_t i, size_t j);
gdl_boolean gdl_fdatapoints_is_missing (const gdl_fdatapoints * g, size_t i, size_t j);

__END_DECLS

#endif /* __GDL_FPOINT_H__ */
