/*  
 * 	sheet/fsheet.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <stdio.h>
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_fsheet.h>

#include "private.c"

gdl_fsheet *
gdl_fsheet_alloc (gdl_fsheet_type * type)
{
	gdl_fsheet * fs;
	
	fs = GDL_MALLOC (gdl_fsheet, 1);
	
	if (!fs)
	{
		GDL_ERROR_VAL("Unable to allocate memory in gdl_fsheet_alloc",
		           GDL_ENOMEM,
		           0);
	}
	
	fs->nr = 0;
	fs->nc = 0;
	fs->type = type;
	fs->_tsep = NULL;
	fs->_fsep = NULL;
	fs->_rsep = NULL;
	fs->_buffer = NULL;
	
	return fs;
}

void
gdl_fsheet_free (gdl_fsheet * fs)
{
	if (fs)
	{
		gdl_fsheet_type_free (fs->type);
		GDL_FREE (fs->_tsep);
		GDL_FREE (fs->_fsep);
		GDL_FREE (fs->_rsep);
		GDL_FREE (fs->_buffer);
		GDL_FREE (fs);
	}
}

int
gdl_fsheet_init (gdl_fsheet * fs, FILE * stream)
{
    int status;
	if (fs == 0 || stream == 0)
		return (-1);
	
	fs->stream = stream;
	
	fs->offset = ftell (stream);
	
	status = gdl_fsheet_init_buffer (fs);
	
	status = gdl_fsheet_init_size (fs);
	
	if (!status)
		return (-1);
	
	return gdl_fsheet_rewind (fs);
}

size_t
gdl_fsheet_nrow (gdl_fsheet * fs)
{
	if (fs == NULL)
		return 0;
	return fs->nr;	
}

size_t
gdl_fsheet_ncolumn (gdl_fsheet * fs)
{
	if (fs == NULL)
		return 0;
	return fs->nc;
}

#include "iterator.c"

const gdl_fsheet_type * gdl_fsheet_default = &_default_type;
