/*  
 * 	fsheet/gdl_fsheet.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_FSHEET_H__
#define __GDL_FSHEET_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_string.h>

__BEGIN_DECLS

typedef struct
{
	size_t rname;
	size_t cname;
	gdl_string * tsep;
	gdl_string * fsep;
	gdl_string * rsep;
	gdl_string * rnfsep; // optional
	gdl_string * cnfsep; // optional
} gdl_fsheet_type;

gdl_fsheet_type * gdl_fsheet_type_default (void);
void gdl_fsheet_type_free (gdl_fsheet_type * T);
gdl_fsheet_type * gdl_fsheet_type_clone (const gdl_fsheet_type * T);
int gdl_fsheet_type_copy (gdl_fsheet_type * dest, const gdl_fsheet_type * src);

typedef struct _gdl_fsheet gdl_fsheet;
typedef struct _gdl_fsheet_itr gdl_fsheet_itr;

gdl_fsheet * gdl_fsheet_alloc  (gdl_fsheet_type * type);
void gdl_fsheet_free (gdl_fsheet * fs);
int gdl_fsheet_init  (gdl_fsheet * fs, FILE * stream);
size_t gdl_fsheet_nrow (gdl_fsheet * fs);
size_t gdl_fsheet_ncolumn (gdl_fsheet * fs);

gdl_fsheet_itr * gdl_fsheet_iterator_c (gdl_fsheet * fs);
gdl_fsheet_itr * gdl_fsheet_iterator_r (gdl_fsheet * fs);
void gdl_fsheet_iterator_free (gdl_fsheet_itr * itr);
char * gdl_fsheet_iterator_column (gdl_fsheet_itr * itr);
char * gdl_fsheet_iterator_row (gdl_fsheet_itr * itr);
size_t gdl_fsheet_iterator_column_idx (gdl_fsheet_itr * itr);
size_t gdl_fsheet_iterator_row_idx (gdl_fsheet_itr * itr);
size_t gdl_fsheet_iterator_is_new_column (gdl_fsheet_itr * itr);
size_t gdl_fsheet_iterator_is_new_row (gdl_fsheet_itr * itr);
char * gdl_fsheet_iterator_cell (gdl_fsheet_itr * itr);
int gdl_fsheet_iterator_next (gdl_fsheet_itr * itr);

__END_DECLS

#endif /* __GDL_FSHEET_H__ */
