/*  
 * 	fsheet/type.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <stdio.h>
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_fsheet.h>

static const gdl_fsheet_type _default_type =
{
	1,
	1,
	"",
	"\t",
	"\n",
	NULL,
	NULL
};

gdl_fsheet_type *
gdl_fsheet_type_default (void)
{
	gdl_fsheet_type * t;
	
	t = GDL_MALLOC (gdl_fsheet_type, 1);
	
	t->rname = 1;
	t->cname = 1;
	t->tsep  = gdl_string_sprintf ("");
	t->fsep  = gdl_string_sprintf ("\t");
	t->rsep  = gdl_string_sprintf ("\n");
	t->rnfsep = NULL;
	t->cnfsep = NULL;	
	
	return t;
}

void
gdl_fsheet_type_free (gdl_fsheet_type * t)
{
	if (t)
	{
		gdl_string_free (t->tsep);
		gdl_string_free (t->fsep);
		gdl_string_free (t->rsep);
		gdl_string_free (t->rnfsep);
		gdl_string_free (t->cnfsep);
	}	
}

gdl_fsheet_type *
gdl_fsheet_type_clone (const gdl_fsheet_type * T)
{
	gdl_fsheet_type * t;
	
	t = GDL_MALLOC (gdl_fsheet_type, 1);
	
	t->rname = T->rname;
	t->cname = T->cname;
	t->tsep = gdl_string_clone (T->tsep);
	t->fsep = gdl_string_clone (T->fsep);
	t->rsep = gdl_string_clone (T->rsep);
	t->rnfsep = gdl_string_clone (T->rnfsep);
	t->cnfsep = gdl_string_clone (T->cnfsep);
	
	return t;
}

int
gdl_fsheet_type_copy (gdl_fsheet_type * dest, const gdl_fsheet_type * src)
{
	if (dest && src)
	{
		gdl_string_free (dest->tsep);
		gdl_string_free (dest->fsep);
		gdl_string_free (dest->rsep);
		gdl_string_free (dest->rnfsep);
		gdl_string_free (dest->cnfsep);
		
		dest->rname = src->rname;
		dest->cname = src->cname;
		dest->tsep = gdl_string_clone (src->tsep);
		dest->fsep = gdl_string_clone (src->fsep);
		dest->rsep = gdl_string_clone (src->rsep);
		dest->rnfsep = gdl_string_clone (src->rnfsep);
		dest->cnfsep = gdl_string_clone (src->cnfsep);
	}
}
