/*  
 *  fview/gdl_fview.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_FVIEW_H__
#define __GDL_FVIEW_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_fpoint.h>
#include <gdl/gdl_fview_type.h>

__BEGIN_DECLS

typedef struct _gdl_fview gdl_fview;

gdl_fview * gdl_fview_alloc (const gdl_fview_type * T);
void gdl_fview_free (gdl_fview * v);

gdl_fview * gdl_fview_fread (FILE * stream);
int gdl_fview_fwrite (FILE * stream, gdl_fview * g);

size_t gdl_fview_factor_size (const gdl_fview * g);
size_t gdl_fview_accession_size (const gdl_fview * g);

gdl_factor     * gdl_fview_add_factor (gdl_fview * g, const gdl_factor_type * T, const char * name);
gdl_accession  * gdl_fview_add_accession (gdl_fview * g, const char * name);
gdl_factor     * gdl_fview_get_factor (const gdl_fview * g, size_t idx);
gdl_accession  * gdl_fview_get_accession (const gdl_fview * g, size_t idx);
gdl_factor     * gdl_fview_search_factor (const gdl_fview * g, const char * name);
gdl_accession  * gdl_fview_search_accession (const gdl_fview * g, const char * name);

gdl_gvalues_get * gdl_fview_get_new (const gdl_fview * g);

int gdl_fview_set_fdatapoint (gdl_fview * g, const gdl_accession * va, const gdl_factor * vl, gdl_fdatapoint * gd);
int gdl_fview_get_value (const gdl_fview * g, const gdl_accession * va, const gdl_factor * vl, gdl_gvalues_get * gb);
gdl_boolean gdl_fview_is_missing (const gdl_fview * g, const gdl_accession * va, const gdl_factor * vl);
size_t gdl_fview_accession_missing_size (const gdl_fview * g, const gdl_accession * a);
size_t gdl_fview_factor_missing_size (const gdl_fview * g, const gdl_factor * l);

int gdl_fview_set_fdatapoint_f (gdl_fview * g, size_t a, size_t l, gdl_fdatapoint * gd);
int gdl_fview_get_value_f (const gdl_fview * g, size_t i, size_t j, gdl_gvalues_get * gb);
gdl_boolean gdl_fview_is_missing_f (const gdl_fview * g, size_t i, size_t j);
size_t gdl_fview_accession_missing_size_f (const gdl_fview * g, size_t a);
size_t gdl_fview_factor_missing_size_f (const gdl_fview * g, size_t l);

int gdl_fview_add (gdl_fview * g, const gdl_string * name, gdl_fview * s, size_t owner);

GDL_VAR const gdl_data_interface * gdl_fview_interface;
GDL_VAR const gdl_fview_type * gdl_fview_standard;
GDL_VAR const gdl_fview_type * gdl_fview_virtual;

__END_DECLS

#endif /* __GDL_FVIEW_H__ */
