/*  
 *  fview/gdl_fview_mask.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_FVIEW_MASK_H__
#define __GDL_FVIEW_MASK_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_fview.h>

__BEGIN_DECLS

size_t gdl_fview_mask_accession_size (const gdl_fview * fview, const gdl_mask * mask);
size_t gdl_fview_mask_factor_size (const gdl_fview * fview, const gdl_mask * mask);
gdl_accession * gdl_fview_mask_get_accession (const gdl_fview * fview, const gdl_mask * mask, size_t i);
gdl_factor * gdl_fview_mask_get_factor (const gdl_fview * fview, const gdl_mask * mask, size_t i);
int gdl_fview_mask_get_value (const gdl_fview * v, const gdl_mask * mask, size_t i, size_t j, gdl_gvalues_get * g);
gdl_boolean gdl_fview_mask_is_missing (const gdl_fview * v, const gdl_mask * mask, size_t i, size_t j);
size_t gdl_fview_mask_accession_missing_size (const gdl_fview * v, const gdl_mask * mask, size_t i);
size_t gdl_fview_mask_factor_missing_size (const gdl_fview * v, const gdl_mask * mask, size_t i);

gdl_mask * gdl_fview_mask_not_informative (const gdl_fview * g, gdl_mask * m, const gdl_entity_type * type);
gdl_mask * gdl_fview_mask_not_informative_recursive (const gdl_fview * g);

size_t GDL_FVIEW_ACCESSION_SIZE (const gdl_fview * fview, const gdl_mask * mask);
size_t GDL_FVIEW_FACTOR_SIZE (const gdl_fview * fview, const gdl_mask * mask);
gdl_accession * GDL_FVIEW_GET_ACCESSION (const gdl_fview * fview, const gdl_mask * mask, size_t i);
gdl_factor * GDL_FVIEW_GET_FACTOR (const gdl_fview * fview, const gdl_mask * mask, size_t i);
gdl_boolean GDL_FVIEW_IS_MISSING (const gdl_fview * fview, const gdl_mask * mask, size_t i, size_t j);
size_t GDL_FVIEW_ACCESSION_MISSING_SIZE (const gdl_fview * fview, const gdl_mask * mask, size_t i);
size_t GDL_FVIEW_FACTOR_MISSING_SIZE (const gdl_fview * fview, const gdl_mask * mask, size_t i);
gdl_gvalues_get * GDL_FVIEW_GET_NEW (const gdl_fview * fview, const gdl_mask * mask);
int GDL_FVIEW_GET_VALUE (const gdl_fview * fview, const gdl_mask * mask, size_t i, size_t j, gdl_gvalues_get * g);

__END_DECLS

#endif
