/*  
 *  fview/gdl_fview_reader.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_FVIEW_READER_H__
#define __GDL_FVIEW_READER_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_gpoint.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_fview.h>

__BEGIN_DECLS

typedef struct _gdl_fview_reader gdl_fview_reader;
typedef struct _gdl_fview_reader_cell gdl_fview_reader_cell;

typedef struct 
{
	char * missing;
	char * sep;
	gdl_boolean has_acc_name;
	gdl_boolean has_fac_header;
	int (*read)(gdl_fview_reader * r);
} gdl_fview_reader_type;

gdl_fview_reader_type * gdl_fview_reader_type_new (const gdl_fview_reader_type * type);
void gdl_fview_reader_type_free (gdl_fview_reader_type * type);
void gdl_fview_reader_type_missing (gdl_fview_reader_type * t, gdl_string * missing);
void gdl_fview_reader_type_separator (gdl_fview_reader_type * t, gdl_string * sep);
void gdl_fview_reader_type_accession_name (gdl_fview_reader_type * type, gdl_boolean has);
void gdl_fview_reader_type_factor_header (gdl_fview_reader_type * t, gdl_boolean has);

struct _gdl_fview_reader_cell
{
	char                  * token;
	const gdl_factor_type * type;
	gdl_fdatapoint        * point;
};

gdl_fview_reader_cell * gdl_fview_reader_cell_alloc ();
void gdl_fview_reader_cell_free (gdl_fview_reader_cell * r);
gdl_fdatapoint * gdl_fview_reader_cell_fdatapoint (const gdl_fview_reader_cell * cell);

struct _gdl_fview_reader
{
	gdl_string * filename;
	gdl_string * error;
	FILE       * stream;
	gdl_fview_reader_type * type;
	gdl_fview * fview;
};

// High level api
gdl_fview_reader * gdl_fview_reader_alloc (gdl_fview_reader_type * type);
void gdl_fview_reader_free (gdl_fview_reader * reader);
int gdl_fview_reader_open (gdl_fview_reader * reader, const gdl_string * filename);
gdl_fview * gdl_fview_reader_parse (gdl_fview_reader * reader);
int gdl_fview_reader_close (gdl_fview_reader * reader);
int gdl_fview_reader_error (gdl_fview_reader * reader, char * format, ...);
// Low level api
int gdl_fview_reader_split_mixture_column_name (gdl_string * col, gdl_string ** factor, gdl_string ** level);
gdl_factor    * gdl_fview_reader_add_factor (gdl_fview_reader * reader, const gdl_factor_type * T, char * name, size_t idx);
gdl_accession * gdl_fview_reader_add_accession (gdl_fview_reader * reader, char * name, size_t idx);
int gdl_fview_reader_update_factor (gdl_factor * factor, const gdl_string * name);
int gdl_fview_reader_set_fdatapoint (gdl_fview_reader * reader, gdl_accession * va, gdl_factor * vl, gdl_fview_reader_cell * cell);

GDL_VAR const gdl_fview_reader_type * gdl_fview_reader_continuous;
GDL_VAR const gdl_fview_reader_type * gdl_fview_reader_mixture;
GDL_VAR const gdl_fview_reader_type * gdl_fview_reader_categorial;

__END_DECLS

#endif /* __GDL_FVIEW_READER_H__ */
