/*  
 *  fview/gdl_fview_type.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_FVIEW_TYPE_H__
#define __GDL_FVIEW_TYPE_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_gpoint.h>
#include <gdl/gdl_fpoint.h>

__BEGIN_DECLS

typedef struct
{
	gdl_string * name;
	size_t       size;
	int (*alloc) (void * data);
	void (*free) (void * data);
	gdl_factor * (*add_factor) (void * data, const gdl_factor_type * T, const gdl_string * name);
	gdl_accession * (*add_accession) (void * data, const gdl_string * name);
	size_t (*factor_size) (const void * data);
	size_t (*accession_size) (const void * data);
	gdl_factor * (*get_factor) (const void * data, size_t i);
	gdl_accession * (*get_accession) (const void * data, size_t i);
	gdl_factor * (*search_factor) (const void * data, const gdl_string * name);
	gdl_accession * (*search_accession) (const void * data, const gdl_string * name);
	gdl_gvalues_get * (*get_new)(const void * data);
	int (*set_fdatapoint) (void * data, const gdl_accession * a, const gdl_factor * l, gdl_fdatapoint * gd);
	int (*get) (const void * data, const gdl_accession * a, const gdl_factor * l, gdl_gvalues_get * gb);
	gdl_boolean (*is_missing) (const void * data, const gdl_accession * a, const gdl_factor * f);
	int (*set_fdatapoint_f) (void * data, size_t a, size_t l, gdl_fdatapoint * gd);
	int (*get_f) (const void * data, size_t a, size_t l, gdl_gvalues_get * gb);
	gdl_boolean (*is_missing_f) (const void * data, size_t a, size_t l);
	void * (*fread)(FILE * stream);
	int (*fwrite)(FILE * stream, void * data);
	int (*add) (void * dest, const gdl_string * name, void * src, size_t owner);
} gdl_fview_type;

const gdl_fview_type * gdl_fview_type_fread (FILE * stream);
int gdl_fview_type_fwrite (FILE * stream, const gdl_fview_type * T);

__END_DECLS

#endif /* __GDL_FVIEW_TYPE_H__ */
