/*  
 *  fview/type.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_fview_type.h>
#include <gdl/gdl_fview.h>

const gdl_fview_type *
gdl_fview_type_fread (FILE * stream)
{
	const gdl_fview_type * T;
	gdl_string * st;
	
	st = gdl_string_fread (stream);
	
	if (!strcmp (st, gdl_fview_standard->name))
	{
		T = gdl_fview_standard;
	}
	else if (!strcmp (st, gdl_fview_virtual->name))
	{
		T = gdl_fview_virtual;
	}
	
	gdl_string_free (st);
	
	return T;	
}

int
gdl_fview_type_fwrite (FILE * stream, const gdl_fview_type * T)
{
	return gdl_string_fwrite (stream, T->name);
}
