/*  
 *  fview/ventry.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

struct _gdl_fview_ventry
{
	size_t size;
	gdl_string ** fviews;
	gdl_entity * entity;
};

typedef struct _gdl_fview_ventry gdl_fview_ventry;

static gdl_fview_ventry *
gdl_fview_ventry_alloc (void)
{
	gdl_fview_ventry * e = GDL_CALLOC (gdl_fview_ventry, 1);
	return e;
}

static void
gdl_fview_ventry_free (void * ve)
{
	if (ve)
	{
		gdl_fview_ventry * e = (gdl_fview_ventry *) ve;
		gdl_entity_free (e->entity);
		GDL_FREE (e->fviews);
		GDL_FREE (e);
	}
}

static int
gdl_fview_ventry_grow (gdl_fview_ventry * ve, size_t size)
{
	if (ve->size)
	{
		gdl_string ** nfviews = GDL_CALLOC (gdl_string *, size);
		memcpy (nfviews, ve->fviews, sizeof (gdl_string *) * ve->size);
		GDL_FREE (ve->fviews);
		ve->fviews = nfviews;
	}
	else
	{
		ve->fviews = GDL_CALLOC (gdl_string *, size);
	}
	ve->size = size;
	
	return GDL_SUCCESS;
}

static void
gdl_fview_ventry_set (gdl_fview_ventry * ve, size_t i, gdl_string * g)
{
	ve->fviews[i] = g;
}

static gdl_data_interface _ventry_interface = 
{
	&gdl_fview_ventry_free,
	NULL,
	NULL,
	NULL,
	NULL
};

static const gdl_data_interface * gdl_fview_ventry_interface = &_ventry_interface;
