/*  
 *  fview/writer.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_fview.h>
#include <gdl/gdl_fview_writer.h>


gdl_fview_writer *
gdl_fview_writer_alloc (gdl_fview_writer_type * type)
{
	gdl_fview_writer * r;
	
	r = GDL_CALLOC (gdl_fview_writer, 1);
	
	r->type = type;
		
	return r;	
}

void
gdl_fview_writer_free (gdl_fview_writer * writer)
{
	if (writer)
	{
		gdl_string_free (writer->filename);
		gdl_string_free (writer->error);
		//gdl_fview_writer_type_free (writer->type);
		GDL_FREE (writer);
	}
}

int
gdl_fview_writer_open (gdl_fview_writer * writer, const gdl_string * filename)
{
	if (writer && filename)
	{
		if (!strcmp(filename, ""))
		{
			writer->stream = stdout;
		}
		else
		{
			writer->stream = gdl_fileopen (filename, "w");	
		}
		
		if (writer->stream)
		{
			gdl_string_free (writer->filename);
			writer->filename = gdl_string_clone (filename);
			gdl_string_free (writer->error);
			writer->error = NULL;
			return GDL_SUCCESS;
		}
		else
			return GDL_EINVAL;
	}
	return GDL_EINVAL;	
}

int
gdl_fview_writer_dump (gdl_fview_writer * writer, const gdl_fview * fview)
{
	(writer->type->write)(writer, fview);
}

int
gdl_fview_writer_close (gdl_fview_writer * writer)
{
	if (writer
	    && writer->stream
	    && writer->stream != stdout)
	{
		gdl_fileclose (writer->filename, writer->stream);
		return GDL_SUCCESS;
	}
	return GDL_EINVAL;
}
