/*  
 * 	gblock/hnblock_source.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:04 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PAR
  	TICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

static size_t FUNCTION (gdl_hnblock, get_index) (const TYPE (gdl_hnblock) *b, BASE *x, va_list ap);

TYPE (gdl_hnblock) *
FUNCTION (gdl_hnblock, alloc) (const size_t p1, const size_t p2, const size_t *dim, size_t ** nested)
{
	size_t i,j,k;
	TYPE (gdl_hnblock) * b;
	
	b = GDL_MALLOC(TYPE (gdl_hnblock), 1);
	
    b->p1    = p1;
    
    b->p2    = p2;
    
    b->p     = p1 + p2;
    
    b->size = 1;
	
	b->dim     = GDL_MALLOC(size_t, b->p);
	
	b->nested  = GDL_CALLOC(size_t *, p2);
	
	b->_nssize = GDL_MALLOC(size_t *, b->p2);
    
    b->_sizes  = GDL_CALLOC(size_t, b->p);
    
    for(i = 0 ; i < b->p; i++)
    {
    	
    	b->dim[i]     = dim[i];
    	
    	b->_sizes[i]  = 0;
    	
    	if ( i < p1 )
    	{
    		
    		b->_sizes[i] = dim[i];
    		
    	} 
    	else
    	{
    		b->_nssize[i - p1] = GDL_CALLOC(size_t, dim[i]);
    		
    		b->nested[i - p1]  = GDL_CALLOC(size_t, dim[i]);
    		
    		for(j = 0; j < dim[i]; j++) 
		    {
		    	
		    	b->nested[i - p1][j] = nested[i - p1][j];
		    	
		    	b->_sizes[i]        += nested[i - p1][j];
		    	
		    	if (j > 0)
		    	{
		    		b->_nssize[i - p1][j] = b->_nssize[i - p1][j-1] + nested[i - p1][j-1];
		    	}
		    	
		    }
    		
    	}
    	    
	    b->size *= b->_sizes[i];
    }
    
    b->_ssize = GDL_MALLOC(size_t, b->p);
    
    for(i = 0 ; i < b->p; i++)
    {
    	b->_ssize[i] = 1;
    	for(j = i+1; j < b->p; j++)
    	{
    		b->_ssize[i] *= b->_sizes[j];
    	}
    }
    
    b->data = GDL_CALLOC(BASE, b->size);
	
	return b;	
}

void
FUNCTION (gdl_hnblock, free) (TYPE (gdl_hnblock) * b)
{
  size_t i;
  GDL_FREE (b->dim);
  GDL_FREE (b->_sizes);
  for( i = 0; i < b->p2; i++)
  { 
  	GDL_FREE (b->nested[i]);
  	GDL_FREE (b->_nssize[i]);
  }
  GDL_FREE (b->nested);
  GDL_FREE (b->_nssize);
  GDL_FREE (b->_ssize);
  GDL_FREE (b->data);
  GDL_FREE (b);
}

BASE
FUNCTION (gdl_hnblock, get) (const TYPE (gdl_hnblock) * b, ...)
{
  va_list ap;
  size_t i, j, k, idx=0;

  va_start (ap, b);              

  idx = FUNCTION (gdl_hnblock, get_index) (b, NULL, ap);  
  
  va_end (ap);               
  
  return b->data[idx];
}

void
FUNCTION (gdl_hnblock, set) ( TYPE(gdl_hnblock) * b, ...)
{
  va_list ap;
  int i, idx=0;
  BASE x = 0;

  va_start (ap, b);      

  idx = FUNCTION (gdl_hnblock, get_index) (b, &x, ap);
  
  va_end (ap);
    
  b->data[idx] = x;
}

static size_t
FUNCTION (gdl_hnblock, get_index) (const TYPE(gdl_hnblock) * b, BASE *x, va_list ap)
{
  size_t i, j, jj, k, idx=0;
  
  for (i = 0; i < b->p1; i++)
  {
  	j = va_arg (ap, size_t);
  	idx += j*b->_ssize[i];
  }
  for (k = 0; i < b->p1 + 2*b->p2; i++)
  {
  	
  	j = va_arg (ap, size_t);
  	
  	if ((i - b->p1) % 2 != 0)
  	{
  		idx += (b->_nssize[k][jj] + j)*b->_ssize[b->p1 + k];
  		k++;
  	}
  	else
  	{
  		jj = j;
  	}
  }
  
  if (x != 0)
  {
  	*x = va_arg (ap, VARG);
  }
  
  return idx;
}

TYPE (gdl_hnblock) *
FUNCTION (gdl_hnblock, fread) (FILE * stream)
{
  size_t status, i;
  TYPE (gdl_hnblock) * b;
  
  b = GDL_MALLOC(TYPE (gdl_hnblock), 1);
  
  status = fread (&b->size, sizeof (size_t), 1, stream);
  GDL_FREAD_STATUS(status, 1);
  status = fread (&b->p1, sizeof (size_t), 1, stream);
  GDL_FREAD_STATUS(status, 1);
  status = fread (&b->p2, sizeof (size_t), 1, stream);
  GDL_FREAD_STATUS(status, 1);  
  b->p   = b->p1 + b->p2;
  b->dim = GDL_MALLOC(size_t, b->p);
  status = fread (b->dim, sizeof (size_t), b->p, stream);
  GDL_FREAD_STATUS(status, b->p);
  b->_ssize = GDL_MALLOC(size_t, b->p);
  status = fread (b->_ssize, sizeof (size_t), b->p, stream);
  GDL_FREAD_STATUS(status, b->p);
  b->_sizes = GDL_MALLOC(size_t, b->p);
  status = fread (b->_sizes, sizeof (size_t), b->p, stream);
  GDL_FREAD_STATUS(status, b->p);
  b->_nssize = GDL_MALLOC(size_t *, b->p2);
  for ( i = 0; i < b->p2; i++) 
  {
  	b->_nssize[i] = GDL_MALLOC(size_t, b->dim[b->p1 + i]);
	status = fread (b->_nssize[i], sizeof (size_t), b->dim[b->p1 + i], stream);
	GDL_FREAD_STATUS(status, b->dim[b->p1 + i]);
  }
  b->nested = GDL_MALLOC(size_t *, b->p2);
  for ( i = 0; i < b->p2; i++) 
  {
  	b->nested[i] = GDL_MALLOC(size_t, b->dim[b->p1 + i]);
	status = fread (b->nested[i], sizeof (size_t), b->dim[b->p1 + i], stream);
	GDL_FREAD_STATUS(status, b->dim[b->p1 + i]);
  }
  b->data = GDL_MALLOC(BASE, b->size);
  status = fread (b->data, sizeof (BASE), b->size, stream);
  GDL_FREAD_STATUS(status, b->size);
  
  return b;
}

int
FUNCTION(gdl_hnblock, fwrite) (FILE * stream, const TYPE (gdl_hnblock) * b)
{
  size_t i, status; 	
	
  status = fwrite (&b->size, sizeof (size_t), 1, stream);
  GDL_FWRITE_STATUS(status, 1);
  status = fwrite (&b->p1, sizeof (size_t), 1, stream);
  GDL_FWRITE_STATUS(status, 1);
  status = fwrite (&b->p2, sizeof (size_t), 1, stream);
  GDL_FWRITE_STATUS(status, 1);
  status = fwrite (b->dim, sizeof (size_t), b->p, stream);
  GDL_FWRITE_STATUS(status, b->p);
  status = fwrite (b->_ssize, sizeof (size_t), b->p, stream);
  GDL_FWRITE_STATUS(status, b->p);
  status = fwrite (b->_sizes, sizeof (size_t), b->p, stream);
  GDL_FWRITE_STATUS(status, b->p);
  for (i = 0; i < b->p2; i++)
  {
  	status = fwrite (b->_nssize[i], sizeof (size_t), b->dim[b->p1 + i], stream);
  	GDL_FWRITE_STATUS(status, b->dim[b->p1 + i]);
  }
  for (i = 0; i < b->p2; i++)
  {
  	status = fwrite (b->nested[i], sizeof (size_t), b->dim[b->p1 + i], stream);
    GDL_FWRITE_STATUS(status, b->dim[b->p1 + i]);
  }
  status = fwrite (b->data, sizeof (BASE), b->size, stream);
  GDL_FWRITE_STATUS(status, b->size);
  
  return GDL_SUCCESS;  
}

