#ifndef __GDL_IO_H__
#define __GDL_IO_H__

#include <stdio.h>

#include <gdl/gdl_common.h>

__BEGIN_DECLS

extern FILE *gdl_fileopen(const char *name, char *mode);  	/* open a file with error messages */
extern void gdl_fileclose(const char *name, FILE *fp);          /* close a file with error messages */
int gdl_isfile(const char * filename);
int gdl_get_next_line(char *buffer, int nn, FILE *fileptr);
int gdl_get_next_token(char *xtemp, int nn, FILE *fileptr);
void gdl_putline(FILE* , char , int );
long gdl_get_identifier(char *thefile);
void gdl_scan_eoln(FILE *f);
int  gdl_eoff(FILE *f);
int  gdl_eoln(FILE *f);
char gdl_gettc(FILE* file);
int  gdl_get_int(void);
int  gdl_nfgets(char *buffer, int nn, FILE *fptr);

void gdl_nrerror(char *error_text);

__END_DECLS

#endif
