#ifndef __GDL_NAN_H__
#define __GDL_NAN_H__

#ifdef INFINITY
# define GDL_POSINF INFINITY
# define GDL_NEGINF (-INFINITY)
#elseif defined(HUGE_VAL)
# define GDL_POSINF HUGE_VAL
# define GDL_NEGINF (-HUGE_VAL)
#else
# define GDL_POSINF (gdl_posinf())
# define GDL_NEGINF (gdl_neginf())
#endif

#ifdef NAN
# define GDL_NAN NAN
#elseif defined(INFINITY)
# define GDL_NAN (INFINITY/INFINITY)
#else
# define GDL_NAN (gdl_nan())
#endif

#define GDL_POSZERO (+0)
#define GDL_NEGZERO (-0)

#endif /* __GDL_NAN_H__ */
