/*
 *  genex/gdl_genex_chromosome.h 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_GENEX_CHROMOSOME_H__
#define __GDL_GENEX_CHROMOSOME_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_genex_gene.h>

__BEGIN_DECLS

typedef struct
{
	size_t        npop;
	size_t        * pop_sizes;
	gdl_string    * name;
	gdl_hashtable * probes;
	gdl_hashtable * genes;
} gdl_genex_chromosome;

gdl_genex_chromosome * gdl_genex_chromosome_alloc (gdl_string * name, const size_t npop);
void gdl_genex_chromosome_free (gdl_genex_chromosome * c);

void gdl_genex_chromosome_add_probe (gdl_genex_chromosome * c, gdl_genex_probe * probe);
gdl_genex_probe * gdl_genex_chromosome_rm_probe (gdl_genex_chromosome * c, gdl_genex_probe * probe);
void gdl_genex_chromosome_add_gene (gdl_genex_chromosome * c, gdl_genex_gene * gene);
gdl_genex_gene * gdl_genex_chromosome_search_gene (const gdl_genex_chromosome * c, const gdl_string * name);
gdl_genex_probe * gdl_genex_chromosome_search_probe (const gdl_genex_chromosome * c, const gdl_string * name);

size_t gdl_genex_chromosome_gene_size (const gdl_genex_chromosome * c);
size_t gdl_genex_chromosome_probe_size (const gdl_genex_chromosome * c);
gdl_genex_gene ** gdl_genex_chromosome_genes (const gdl_genex_chromosome * c);
gdl_genex_probe ** gdl_genex_chromosome_probes (const gdl_genex_chromosome * c);

gdl_genex_chromosome * gdl_genex_chromosome_fread (FILE * stream);
int gdl_genex_chromosome_fscanf (FILE * stream, gdl_genex_chromosome * c);
int gdl_genex_chromosome_fwrite (FILE * stream, const gdl_genex_chromosome * c);

int gdl_genex_chromosome_fscanf_refseq (FILE * stream, gdl_genex_chromosome * c, gdl_boolean force);

__END_DECLS

#endif
