/*
 *  genex/gdl_genex_gene.h 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_GENEX_GENE_H__
#define __GDL_GENEX_GENE_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_genex_block.h>

__BEGIN_DECLS

typedef struct
{
	long   id;
	long   start; // deprecated see txStart
	long   end;   // deprecated see txEnd
	long   txStart; // transcription start position
	long   txEnd;   // transcription end position
	long cdsStart;  // coding region start
	long cdsEnd;    // coding region end
	size_t exonCount; // Number of exons
	long * exonStarts; // exon start positions
	long * exonEnds;   // exon end positions
	gdl_string * name;
	size_t size;
	gdl_genex_block ** blocks;
	unsigned char ignore;
	unsigned char strand;
} gdl_genex_gene;

gdl_genex_gene * gdl_genex_gene_alloc (gdl_string * name, const long id);
void gdl_genex_gene_free (gdl_genex_gene * g);
gdl_genex_gene * gdl_genex_gene_clone (const gdl_genex_gene * gene);

void gdl_genex_gene_add_block (gdl_genex_gene * g, gdl_genex_block * b);
gdl_genex_block * gdl_genex_gene_search_block (const gdl_genex_gene * g, const long start, const long end, const unsigned char strand);

void gdl_genex_gene_remove_block (gdl_genex_gene * g, size_t b);
void gdl_genex_gene_merge_block (gdl_genex_gene * g, size_t b1, size_t b2);

gdl_genex_gene * gdl_genex_gene_fread (FILE * stream, gdl_genex_probe ** probes);
int gdl_genex_gene_fwrite (FILE * stream, const gdl_genex_gene * g);

__END_DECLS

#endif
