/*  
 * 	entity/gdl_allele.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_ALLELE_H__
#define __GDL_ALLELE_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_entity.h>

__BEGIN_DECLS

typedef gdl_entity gdl_allele;
typedef gdl_allele * gdl_allele_ptr;

gdl_allele * gdl_allele_alloc (void);
gdl_allele * gdl_allele_new (const char * name);
void gdl_allele_free (gdl_allele * va);

GDL_VAR const gdl_allele * gdl_allele_missing;
GDL_VAR const gdl_allele * gdl_allele_recessive;
GDL_VAR const gdl_entity_type * GDL_ALLELE;
GDL_VAR const gdl_entity_type * GDL_ALLELE_MISSING;
GDL_VAR const gdl_entity_type * GDL_ALLELE_RECESSIVE;

__END_DECLS

#endif /* __GDL_ALLELE_H__ */
