/*  
 * 	entity/gdl_chromosome.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_CHROMOSOME_H__
#define __GDL_CHROMOSOME_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_math.h>
#include <gdl/gdl_entity.h>
#include <gdl/gdl_locus.h>

__BEGIN_DECLS

typedef gdl_entity gdl_chromosome;

typedef enum
{
	gdl_gdistance_unknown,
	gdl_gdistance_centi_morgan,
	gdl_gdistance_morgan,
	gdl_gdistance_base,
	gdl_gdistance_kilo_base,
	gdl_gdistance_undefined
} gdl_gdistance_type;

gdl_gdistance_type gdl_gdistance_type_parse (const gdl_string * string);

typedef struct 
{
	gdl_gdistance_type type;
	double value;
} gdl_gdistance;

gdl_gdistance * gdl_gdistance_alloc (const gdl_gdistance_type type);
void gdl_gdistance_free (gdl_gdistance * d);
gdl_gdistance * gdl_gdistance_convert (const gdl_gdistance * d, const gdl_gdistance_type type);
int gdl_gdistance_fprintf (FILE * stream, const gdl_gdistance * d);
gdl_gdistance * gdl_gdistance_fscanf (FILE * stream);
gdl_gdistance * gdl_gdistance_sscanf (const gdl_string * string);
gdl_boolean gdl_gdistance_is_defined (const gdl_gdistance * d);

gdl_chromosome * gdl_chromosome_alloc (void);
gdl_chromosome * gdl_chromosome_new (const char * name);
void gdl_chromosome_free (gdl_chromosome * c);
int gdl_chromosome_init (gdl_chromosome * vc, size_t size);
int gdl_chromosome_push (gdl_chromosome * c, gdl_locus * l, size_t owner);
int gdl_chromosome_add (gdl_chromosome * c, gdl_locus * l, const gdl_gdistance * d, size_t owner);
size_t gdl_chromosome_size (const gdl_chromosome * c);
gdl_locus * gdl_chromosome_get (const gdl_chromosome * c, size_t i);
int gdl_chromosome_search (const gdl_chromosome * c, const gdl_locus * l);
gdl_gdistance * gdl_chromosome_get_distance (const gdl_chromosome * c, size_t i, size_t j);
gdl_gdistance * gdl_chromosome_search_distance (const gdl_chromosome * c, const gdl_locus * f, const gdl_locus * t);

gdl_locus_mask * gdl_chromosome_get_mask (const gdl_chromosome * c, const gdl_locus_mask * mask);

int gdl_chromosome_fprintf (FILE * stream, const gdl_chromosome * vc);

GDL_VAR const gdl_entity_type * GDL_CHROMOSOME;

__END_DECLS

#endif /* __GDL_CHROMOSOME_H__ */
