/*  
 * 	entity/gdl_entity.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:04 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_string.h>
 
#ifndef __GDL_ENTITY_H__
#define __GDL_ENTITY_H__

typedef struct
{
	size_t size;
	gdl_string * name;
	int (*alloc) (void * vstate);
	void (*free) (void * vstate);
	int (*compare) (const void * vstate1, const void * vstate2);
	int (*copy) (void * vstate1, const void * vstate2);
	int (*fread) (FILE * stream, void * vstate);
	int (*fwrite) (FILE * stream, const void * vstate);
} gdl_entity_type;

typedef struct 
{
	const gdl_entity_type * type;
	void * state;
	size_t     idx;
	gdl_string * name;
	void       * extra;
} gdl_entity;

gdl_entity * gdl_entity_alloc (const gdl_entity_type * type);
void gdl_entity_free (gdl_entity * a);
gdl_entity * gdl_entity_clone (const gdl_entity * a);
gdl_entity * gdl_entity_fread (FILE * stream);
int gdl_entity_fwrite (FILE * stream, const gdl_entity * a);
void gdl_entity_set_idx (gdl_entity * entity, const size_t idx);
void gdl_entity_set_name (gdl_entity * entity, const gdl_string * name);

const gdl_string * gdl_entity_get_name (const gdl_entity * entity);
size_t gdl_entity_get_idx (const gdl_entity * entity);
const gdl_entity_type * gdl_entity_get_type (const gdl_entity * entity);

typedef struct
{
	size_t _size;
	size_t slot;
	size_t size;
	size_t * idx;
	size_t * ridx;
} gdl_entity_mask;

gdl_entity_mask * gdl_entity_mask_alloc ();
gdl_entity_mask * gdl_entity_mask_new (size_t size);
gdl_entity_mask * gdl_entity_mask_clone (const gdl_entity_mask * m);
gdl_entity_mask * gdl_entity_mask_ident (size_t size);
void gdl_entity_mask_free (gdl_entity_mask * m);

gdl_entity_mask * gdl_entity_mask_fread (FILE * stream);
int gdl_entity_mask_fwrite (FILE * stream, const gdl_entity_mask * m);

size_t gdl_entity_mask_size (const gdl_entity_mask * m);
size_t gdl_entity_mask_idx (const gdl_entity_mask * m, size_t i);
int gdl_entity_mask_ridx (const gdl_entity_mask * m, size_t i);
int gdl_entity_mask_add (gdl_entity_mask * m, const gdl_entity * e);
int gdl_entity_mask_add_idx (gdl_entity_mask * m, size_t idx);
void gdl_entity_mask_remove (gdl_entity_mask * m, size_t idx);
void gdl_entity_mask_union (gdl_entity_mask * dest, const gdl_entity_mask * src);
void gdl_entity_mask_inter (gdl_entity_mask * dest, const gdl_entity_mask * src);
void gdl_entity_mask_inter_over (gdl_entity_mask * dest, const gdl_entity_mask * src, gdl_entity_mask * m1, gdl_entity_mask * m2);
gdl_entity_mask * gdl_entity_mask_over (const gdl_entity_mask * src, const gdl_entity_mask * sub);
int gdl_entity_mask_compare (const gdl_entity_mask * m1, const gdl_entity_mask * m2);
gdl_entity_mask * gdl_entity_mask_reverse (const gdl_entity_mask * m, size_t n);

GDL_VAR const gdl_data_interface   * gdl_entity_interface;
GDL_VAR const gdl_data_interface   * gdl_entity_mask_interface;
GDL_VAR const gdl_entity_type      * GDL_ENTITY;

#endif /*__GDL_ENTITY_H__*/
