/*  
 * 	entity/gdl_genotype.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:04 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_GENOTYPE_H__
#define __GDL_GENOTYPE_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_entity.h>
#include <gdl/gdl_allele.h>

__BEGIN_DECLS

typedef gdl_entity gdl_genotype;
typedef gdl_genotype * gdl_genotype_ptr;

gdl_genotype * gdl_genotype_alloc (void);
void gdl_genotype_free (gdl_genotype * g);

int gdl_genotype_add (gdl_genotype * vg, gdl_allele * va, size_t owner);
int gdl_genotype_add_missing (gdl_genotype * vg);
int gdl_genotype_add_recessive (gdl_genotype * vg);
gdl_list_itr * gdl_genotype_allele_iterator (const gdl_genotype * g);
gdl_allele * gdl_genotype_get_allele (const gdl_genotype * vg, size_t p);
size_t gdl_genotype_size (const gdl_genotype * vg);
gdl_boolean gdl_genotype_is_homozygous (const gdl_genotype * vg);
gdl_boolean gdl_genotype_has_missing (const gdl_genotype * vg);
gdl_boolean gdl_genotype_has_recessive (const gdl_genotype * vg);

GDL_VAR const gdl_entity_type * GDL_GENOTYPE;

__END_DECLS

#endif /* __GDL_GENOTYPE_H__ */
