/*  
 * 	entity/gdl_locus.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:04 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_LOCUS_H__
#define __GDL_LOCUS_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_entity.h>
#include <gdl/gdl_allele.h>
#include <gdl/gdl_genotype.h>

__BEGIN_DECLS

typedef enum _gdl_locus_mode gdl_locus_mode;

typedef gdl_entity gdl_locus;
typedef gdl_locus * gdl_locus_ptr;
typedef gdl_entity_mask gdl_locus_mask;

gdl_locus * gdl_locus_alloc (void);
gdl_locus * gdl_locus_new (const char * name);
void gdl_locus_free (gdl_locus * l);

void gdl_locus_add_allele (gdl_locus * vl, gdl_allele ** va, size_t owner);
gdl_allele * gdl_locus_add_recessive (gdl_locus * vl);
void gdl_locus_add_genotype (gdl_locus * vl, gdl_genotype ** va, size_t owner);
gdl_allele   * gdl_locus_get_allele (const gdl_locus * vl, size_t idx);
gdl_genotype * gdl_locus_get_genotype (const gdl_locus * vl, size_t idx);
gdl_allele   * gdl_locus_search_allele (const gdl_locus * vl, const gdl_string * name);
gdl_genotype * gdl_locus_search_genotype (const gdl_locus * vl, const gdl_string * name);
size_t gdl_locus_allele (const gdl_locus * vl);
size_t gdl_locus_genotype (const gdl_locus * vl);
size_t gdl_locus_informative_genotype (const gdl_locus * vl);
gdl_locus * gdl_locus_resolve_genotype (const gdl_locus * vl);

GDL_VAR const gdl_entity_type * GDL_LOCUS;

__END_DECLS

#endif /* __GDL_LOCUS_H__ */
