/* gfeatures/gdl_gfeatures.h
 * 
 * Copyright (C) 2008 Jean-Baptiste Veyrieras
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GDL_GFEATURES_H__
#define __GDL_GFEATURES_H__

#include <stdlib.h>
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_dictionary.h>

__BEGIN_DECLS

typedef struct
{
	gdl_string * seqid;
	size_t size;
	void ** records;
	gdl_dictionary * dico;
	gdl_hashtable * _rec_id_buffer;
	gdl_list      * _rec_buffer;
} gdl_gfeatures_landmark;

gdl_gfeatures_landmark * gdl_gfeatures_landmark_alloc (const gdl_string * seqid);
void gdl_gfeatures_landmark_expand (gdl_gfeatures_landmark * l);

typedef struct _gdl_gfeatures_type gdl_gfeatures_type;

struct _gdl_gfeatures_type
{
	gdl_string * name;
	gdl_gfeatures_landmark ** (*alloc)(const gdl_string * file, size_t * nlandmark, gdl_dictionary * dictionary);
	gdl_string ** (*alloc_light)(const gdl_string * file, const gdl_string * odir, size_t * nlandmark, gdl_dictionary * dictionary);
	void (*free) (gdl_gfeatures_landmark * l);
	gdl_gfeatures_landmark * (*fread)(FILE * stream);
	int (*fwrite)(FILE * stream, const gdl_gfeatures_landmark * l);
	int (*fprintf)(FILE * stream, const gdl_gfeatures_landmark * l);
	gdl_gfeatures_landmark * (*convert)(const gdl_gfeatures_landmark * l, const gdl_gfeatures_type * TO);
};

typedef struct
{
	const gdl_gfeatures_type * type;
	size_t size;
	gdl_string               * light_dir;
	gdl_string              ** light_landmarks;
	gdl_gfeatures_landmark  ** landmarks;
	gdl_hashtable            * landmark_id2idx;
	gdl_dictionary * dico;
} gdl_gfeatures;

gdl_gfeatures * gdl_gfeatures_alloc (const gdl_gfeatures_type * T, const gdl_string * file);
gdl_gfeatures * gdl_gfeatures_alloc_light (const gdl_gfeatures_type * T, const gdl_string * file, const gdl_string * light_dir);
void gdl_gfeatures_free (gdl_gfeatures * g);
size_t gdl_gfeatures_size (const gdl_gfeatures * g);
gdl_gfeatures_landmark * gdl_gfeatures_get (const gdl_gfeatures * g, size_t c);
gdl_gfeatures_landmark * gdl_gfeatures_lookup (const gdl_gfeatures * g, const gdl_string * seqid);
int gdl_gfeatures_update (gdl_gfeatures * g, gdl_gfeatures_landmark * l);
void gdl_gfeatures_clean (const gdl_gfeatures * g, gdl_gfeatures_landmark * l);

gdl_gfeatures * gdl_gfeatures_fread (FILE * stream);
int gdl_gfeatures_fwrite (FILE * stream, const gdl_gfeatures * g);
int gdl_gfeatures_fprintf (FILE * stream, const gdl_gfeatures * g);

#define GDL_GFEATURES_LIGHT_EXT "gfz"
#define GDL_GFEATURES_LIGHT_FILE(a,b)(gdl_string_sprintf ("%s/%s.%s", (a), (b), GDL_GFEATURES_LIGHT_EXT))

GDL_VAR const gdl_gfeatures_type * gdl_gfeatures_gff3;

__END_DECLS

#endif
