/* gfeatures/gdl_gfeatures_gff3.h
 * 
 * Copyright (C) 2008 Jean-Baptiste Veyrieras
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GDL_GFEATURES_GFF3_H__
#define __GDL_GFEATURES_GFF3_H__

#include <stdlib.h>
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_hash.h>

__BEGIN_DECLS

#define GFF3_SEPARATOR           '\t'
#define GFF3_ATTRIBUTE_SEPARATOR ';'
#define GFF3_ATTRIBUTE_DEFINE    '='
#define GFF3_UNDEFINED_FIELD     "."
#define GFF3_ATTRIBUTE_MULTISEP  ','

typedef struct _gdl_gfeatures_gff3_record gdl_gfeatures_gff3_record;

struct _gdl_gfeatures_gff3_record
{
	size_t idx;
	long start;
	long end;
	unsigned char strand;
	size_t source_d;
	size_t type_d;
	double score;
	int phase;
	gdl_hashtable * attributes;
	size_t nchild;
	gdl_gfeatures_gff3_record ** children;
	size_t nparent;
	gdl_gfeatures_gff3_record ** parents;
};

gdl_gfeatures_gff3_record * gdl_gfeatures_gff3_record_alloc (void);
void gdl_gfeatures_gff3_record_free (gdl_gfeatures_gff3_record * r);
int gdl_gfeatures_gff3_record_add_parent (gdl_gfeatures_gff3_record * child, gdl_gfeatures_gff3_record * parent);
int gdl_gfeatures_gff3_record_fprintf (FILE * stream, const gdl_gfeatures_landmark * l, const gdl_gfeatures_gff3_record * rec);
int gdl_gfeatures_gff3_record_fprintf2 (FILE * stream, const gdl_string * new_landmark, const gdl_gfeatures_landmark * l, const gdl_gfeatures_gff3_record * rec);
int gdl_gfeatures_gff3_record_and_children_fprintf (FILE * stream, const gdl_gfeatures_landmark * l, const gdl_gfeatures_gff3_record * rec);

gdl_boolean gdl_gfeatures_gff3_record_is_of_type (const gdl_gfeatures * feature, const  gdl_gfeatures_gff3_record * rec, const gdl_string * type);
gdl_boolean gdl_gfeatures_gff3_record_is_inside (const gdl_gfeatures_gff3_record * rec1, const gdl_gfeatures_gff3_record * rec2);
size_t gdl_gfeatures_gff3_record_size (const gdl_gfeatures_gff3_record * rec);
int gdl_gfeatures_gff3_record_parse_target (const gdl_gfeatures_gff3_record * rec, gdl_string ** target_id, long * target_start, long * target_end, unsigned char * strand);
int gdl_gfeatures_gff3_within (gdl_gfeatures_landmark * l, const long from, const long to, int * from_idx, int * to_idx);
size_t gdl_gfeatures_gff3_record_children_of_type (const gdl_gfeatures * feature, const  gdl_gfeatures_gff3_record * rec, const gdl_string * type);

__END_DECLS

#endif
