/*  
 *  gglm/odriver.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#include <gdl/gdl_common.h>
#include <gdl/gdl_meta.h>
#include <gdl/gdl_odb.h>
#include <gdl/gdl_gglm_result.h>

static gdl_meta *
_gdl_gglm_result_meta (const void * obj)
{
	gdl_meta_tag * tag;
	gdl_meta * meta = gdl_meta_alloc ();
	gdl_gglm_result * work = (gdl_gglm_result *) obj;
	
	tag = gdl_meta_tag_alloc ();
	gdl_meta_tag_name (tag, "size");
	gdl_meta_tag_value (tag, "%d", gdl_gglm_result_size (work));
	gdl_meta_add (meta, tag);
	
	return meta;
}

static void *
_gdl_gglm_result_fread (FILE * stream)
{
	return gdl_gglm_result_fread (stream);
}

static int
_gdl_gglm_result_fwrite (FILE * stream, const void * obj)
{
	const gdl_gglm_result * result = (gdl_gglm_result *) obj;
	return gdl_gglm_result_fwrite (stream, result);
}

static int
_gdl_gglm_result_fprintf (FILE * stream, const void * obj)
{
	const gdl_gglm_result * result = (gdl_gglm_result *) obj;
	return gdl_gglm_result_fprintf (stream, result);
}

static const gdl_odriver _gdl_gglm_result_driver =
{
    "gdl_gglm_result",
    "1.0",
    &_gdl_gglm_result_meta,
    &_gdl_gglm_result_fread,
    &_gdl_gglm_result_fwrite,
    &_gdl_gglm_result_fprintf
};

const gdl_odriver * gdl_gglm_result_driver = &_gdl_gglm_result_driver;
