/*  
 *  gmap/wabsolute.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:41 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_gmap.h>
#include <gdl/gdl_gmap_writer.h>

static int
__gdl_gmap_writer_absolute (gdl_gmap_writer * w, const gdl_gmap * gmap)
{
	if ((w && w->stream) && gmap)
	{
		size_t i, j, k, kk, ng, nc, nl;
		gdl_gdistance * d;
		
		fprintf (w->stream, "genome\tchromosome\tlocus\tdistance\tunit\n");
		
		ng = gdl_gmap_size (gmap);
		
		for (i = 0; i < ng; i++)
		{
			gdl_genome * genome = gdl_gmap_get (gmap, i);
			nc = gdl_genome_size (genome);
			for (j = 0; j < nc; j++)
			{
				gdl_chromosome * chrom = gdl_genome_get (genome, j);
				nl = gdl_chromosome_size (chrom);
				for (kk = k = 0; k < nl; k++)
				{
					gdl_locus * locus = gdl_chromosome_get (chrom, k);
					fprintf (w->stream, "%s\t%s\t%s\t", gdl_entity_get_name (genome),
					                       gdl_entity_get_name (chrom),
					                       gdl_entity_get_name (locus));	
					d = gdl_chromosome_get_distance (chrom, kk, k);
					if (!d)
					{
						kk = k;
						fprintf (w->stream, "-\t-\n");
					}
					else
					{
						gdl_gdistance_fprintf (w->stream, d);
						fprintf (w->stream, "\n");
					}
					gdl_gdistance_free (d);
				}
			}
		}
		
		return GDL_SUCCESS;
	}
	
	return GDL_EINVAL;
}

static const gdl_gmap_writer_type _gdl_gmap_writer_absolute =
{
	"gdl_gmap_writer_absolute",
	&__gdl_gmap_writer_absolute
};

const gdl_gmap_writer_type * gdl_gmap_writer_absolute = &_gdl_gmap_writer_absolute;
