/*  
 * 	gmatrix/gdl_gmatrix.h 
 *  
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_gpoint.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_glabels.h>

#ifndef __GDL_GMATRIX_H__
#define __GDL_GMATRIX_H__

__BEGIN_DECLS

typedef struct
{
	size_t size1;
	size_t size2;
	size_t nl;
	size_t * nc;
	size_t * tnc;
	gdl_vector * rw;
	gdl_matrix * data;
	const gdl_gview * gview;
	const gdl_gview_wrapper * gwrap;
	const gdl_mask * mask;
	const gdl_clustering * clust;
	gdl_boolean accession_cluster;
	gdl_boolean last_allele;
} gdl_gmatrix;

typedef struct
{
	gdl_string * name;
	gdl_string * acronym;
	int (*alloc) (gdl_gmatrix * g, const gdl_gview * gview, const gdl_mask * mask, const gdl_clustering * clustering, gdl_boolean last_allele);
	int (*wrapper_alloc) (gdl_gmatrix * g, const gdl_gview_wrapper * gview, gdl_boolean accession_cluster, gdl_boolean last_allele);
	int (*wrapper_mask_alloc) (gdl_gmatrix * g, const gdl_gview_wrapper * gview, const gdl_mask * mask, gdl_boolean last_allele);
} gdl_gmatrix_type;

const gdl_gmatrix_type * gdl_gmatrix_type_fread (FILE * stream);
int gdl_gmatrix_type_fwrite (FILE * stream, const gdl_gmatrix_type * T);

gdl_gmatrix * gdl_gmatrix_alloc (const gdl_gmatrix_type * T, const gdl_gview * gview, const gdl_mask * mask, const gdl_clustering * clustering, gdl_boolean last_allele);
gdl_gmatrix * gdl_gmatrix_wrapper_alloc (const gdl_gmatrix_type * T, const gdl_gview_wrapper * gwrap, gdl_boolean accession_cluster, gdl_boolean last_allele);
gdl_gmatrix * gdl_gmatrix_wrapper_mask_alloc (const gdl_gmatrix_type * T, const gdl_gview_wrapper * gwrap, const gdl_mask * mask, gdl_boolean last_allele);

void gdl_gmatrix_free (gdl_gmatrix * m);

size_t gdl_gmatrix_row_size (const gdl_gmatrix * m);
size_t gdl_gmatrix_column_size (const gdl_gmatrix * m);
size_t gdl_gmatrix_accession_size (const gdl_gmatrix * m);
size_t gdl_gmatrix_locus_size (const gdl_gmatrix * m);
size_t gdl_gmatrix_locus_column_size (const gdl_gmatrix * m, size_t i);
size_t gdl_gmatrix_locus_first_column (const gdl_gmatrix * m, size_t i);
double gdl_gmatrix_get (const gdl_gmatrix * m, size_t i, size_t j);
void gdl_gmatrix_set (gdl_gmatrix * m, size_t i, size_t j, double x);
double gdl_gmatrix_locus_column_get (const gdl_gmatrix * m, size_t i, size_t j, size_t a);
void gdl_gmatrix_locus_column_set (gdl_gmatrix * m, size_t i, size_t j, size_t a, double x);
gdl_gvalues * gdl_gmatrix_locus_get (const gdl_gmatrix * m, size_t i, size_t j);
void gdl_gmatrix_locus_set (gdl_gmatrix * m, size_t i, size_t j, const gdl_gvalues * x);
void gdl_gmatrix_locus_set_missing (gdl_gmatrix * m, size_t i, size_t j);
gdl_boolean gdl_gmatrix_locus_is_missing (const gdl_gmatrix * m, size_t i, size_t j);
void gdl_gmatrix_locus_set_all (gdl_gmatrix * m, size_t i, size_t j, double x);
double gdl_gmatrix_get_row_weight (const gdl_gmatrix * m, size_t i);
const gdl_vector  * gdl_gmatrix_get_row_weights (const gdl_gmatrix * m);
const gdl_matrix  * gdl_gmatrix_get_matrix (const gdl_gmatrix * m);

gdl_glabels * gdl_gmatrix_get_labels (const gdl_gmatrix * m);
gdl_mask    * gdl_gmatrix_get_mask (const gdl_gmatrix * m);

int gdl_gmatrix_fprintf (FILE * stream, const gdl_gmatrix * m);

int gdl_gmatrix_permut_accession_by_locus (gdl_gmatrix * m, const gdl_rng * rng);

GDL_VAR const gdl_gmatrix_type * gdl_gmatrix_allele;
GDL_VAR const gdl_gmatrix_type * gdl_gmatrix_genotype;

__END_DECLS

#endif /*__GDL_GMATRIX_H__*/
