/*  
 * 	gpart/gdl_gpartition.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:41 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_GPARTITION_H__
#define __GDL_GPARTITION_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>

__BEGIN_DECLS

typedef struct _gdl_gpartition gdl_gpartition;

typedef struct
{
	void * data;
	gdl_mask * mask;
} gdl_gpartition_state;

typedef enum _gdl_gligation_type gdl_gligation_type;

typedef gdl_gpartition_state ** (*gdl_gpartition_fonction) (const gdl_gview * g, const gdl_mask * m, size_t * ns, void * extra);
typedef void (*gdl_gpartition_state_free) (void * data);
typedef int  (*gdl_gligation_fonction) (gdl_gpartition_state * cur, const gdl_gpartition_state * next, const gdl_gligation_type * T, void * extra);
typedef int  (*gdl_gligation_update) (gdl_gpartition_state * cur, const gdl_gligation_type * T, void * extra);

gdl_gpartition * gdl_gpartition_alloc (const gdl_gview * g, const gdl_mask * m);
gdl_gpartition * gdl_gpartition_new (gdl_gpartition_state ** part, size_t np);
void gdl_gpartition_free (gdl_gpartition * g, gdl_gpartition_state_free free);

int gdl_gpartition_init (gdl_gpartition * g, gdl_gpartition_fonction f, void * extra);
size_t gdl_gpartition_size (const gdl_gpartition * g);
size_t gdl_gpartition_eligible_size (const gdl_gpartition * g, const gdl_gligation_type * T);

gdl_gpartition_state * gdl_gpartition_get (const gdl_gpartition * g, size_t i);

int gdl_gpartition_ligation (gdl_gpartition * g, const gdl_gligation_type * T, gdl_gligation_fonction f, gdl_gpartition_state_free free, gdl_gligation_update update, void * extra);

GDL_VAR const gdl_gligation_type * gdl_gligation_progressive;
GDL_VAR const gdl_gligation_type * gdl_gligation_hierarchical;

__END_DECLS

#endif
