/*  
 *  gpca/acov.c
 *  
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:42 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_gmatrix.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_pca.h>
#include <gdl/gdl_ppca.h>
#include <gdl/gdl_gpca.h>

static gdl_gmatrix *
gdl_gpca_locus_allele_covariance_gmatrix (const gdl_gview_wrapper * gwrap)
{
	return gdl_gmatrix_wrapper_alloc (gdl_gmatrix_allele, gwrap, gdl_true, gdl_false);
}

//static gdl_gmatrix *
//gdl_gpca_locus_allele_covariance_hmatrix (const gdl_hview * hview)
//{
//	return gdl_gmatrix_halloc (gdl_gmatrix_allele, hview);
//}

static gdl_pca_workspace *
gdl_gpca_locus_allele_covariance_pca (void)
{
	return gdl_pca_workspace_alloc (gdl_pca_covariance);
}

static gdl_ppca_workspace *
gdl_gpca_locus_allele_covariance_ppca (void)
{
	return gdl_ppca_workspace_alloc (gdl_ppca_covariance, gdl_rng_alloc (gdl_rng_default));
}

static gdl_matrix *
gdl_gpca_locus_allele_covariance_matrix (const gdl_gmatrix * g)
{
	const gdl_matrix * X = gdl_gmatrix_get_matrix (g);
	gdl_matrix * XX = gdl_matrix_alloc (X->size1, X->size2);
	gdl_matrix_memcpy (XX, X);
	return XX;
}

static gdl_vector *
gdl_gpca_locus_allele_covariance_weights (const gdl_gmatrix * g)
{
	const gdl_vector * w = gdl_gmatrix_get_row_weights (g);
	gdl_vector * ww = gdl_vector_alloc (w->size);
	gdl_vector_memcpy (ww, w);
	return ww;
}

static const gdl_gpca_workspace_type _gdl_gpca_locus_allele_covariance =
{
	"gdl_gpca_locus_allele_covariance",
	"lacov",
	&gdl_gpca_locus_allele_covariance_gmatrix,
//	&gdl_gpca_locus_allele_covariance_hmatrix,
	&gdl_gpca_locus_allele_covariance_pca,
	&gdl_gpca_locus_allele_covariance_ppca,
	&gdl_gpca_locus_allele_covariance_matrix,
	&gdl_gpca_locus_allele_covariance_weights
};

const gdl_gpca_workspace_type * gdl_gpca_locus_allele_covariance = &_gdl_gpca_locus_allele_covariance;
