/*  
 *  gpca/gdl_gpca.h 
 *  
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:42 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#ifndef __GDL_GPCA_H__
#define __GDL_GPCA_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_gmatrix.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_pca.h>
#include <gdl/gdl_ppca.h>

__BEGIN_DECLS

typedef struct
{
	gdl_string  * name;
	gdl_string  * acronym;
	gdl_gmatrix * (*gmatrix)(const gdl_gview_wrapper * gwrap);
	gdl_pca_workspace * (*pca)(void);
	gdl_ppca_workspace * (*ppca)(void);
	gdl_matrix  * (*matrix) (const gdl_gmatrix * m);
	gdl_vector  * (*weights)(const gdl_gmatrix * m);
} gdl_gpca_workspace_type;

const gdl_gpca_workspace_type * gdl_gpca_workspace_type_fread (FILE * stream);
int gdl_gpca_workspace_type_fwrite (FILE * stream, const gdl_gpca_workspace_type * T);

typedef struct _gdl_gpca_workspace_type_registry gdl_gpca_workspace_type_registry;

const gdl_gpca_workspace_type_registry * gdl_gpca_workspace_type_registry_get ();
const gdl_gpca_workspace_type * gdl_gpca_workspace_type_registry_search (const gdl_gpca_workspace_type_registry * r, const gdl_string * name);

typedef struct 
{
	const gdl_gpca_workspace_type * type;
	size_t            _naxe;
	size_t            algo;
	gdl_matrix        * U;
	gdl_gmatrix       * gmatrix;
	gdl_pca_workspace * pca;
	gdl_ppca_workspace * ppca;
} gdl_gpca_workspace;

gdl_gpca_workspace * gdl_gpca_workspace_alloc (const gdl_gpca_workspace_type * T, const gdl_gview_wrapper * gwrap);

void gdl_gpca_workspace_free (gdl_gpca_workspace * m);

int gdl_gpca_workspace_perform (gdl_gpca_workspace * m, size_t naxe);

const gdl_gpca_workspace_type * gdl_gpca_workspace_get_type (const gdl_gpca_workspace * r);
const gdl_gmatrix * gdl_gpca_workspace_data (const gdl_gpca_workspace * r);
const gdl_matrix * gdl_gpca_workspace_projection (const gdl_gpca_workspace * r);
const gdl_matrix * gdl_gpca_workspace_rotation (const gdl_gpca_workspace * r);
const gdl_vector * gdl_gpca_workspace_weights (const gdl_gpca_workspace * r);
const gdl_vector * gdl_gpca_workspace_tracy_widom (const gdl_gpca_workspace * r);

size_t gdl_gpca_workspace_scree_threshold (const gdl_gpca_workspace * w, double threshold) ;

GDL_VAR const gdl_gpca_workspace_type * gdl_gpca_locus_allele_covariance;
GDL_VAR const gdl_gpca_workspace_type * gdl_gpca_locus_allele_correlation;
GDL_VAR const gdl_gpca_workspace_type * gdl_gpca_accession_allele_covariance;
GDL_VAR const gdl_gpca_workspace_type * gdl_gpca_accession_allele_correlation;
GDL_VAR const gdl_gpca_workspace_type * gdl_gpca_accession_allele_euclidean_distance;

__END_DECLS

#endif /* __GDL_GPCA_H__ */
