/*  
 *  gpca/gdl_gpca_tag_result.h 
 *  
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:42 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#ifndef __GDL_GPCA_RESULT_H__
#define __GDL_GPCA_RESULT_H_

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_odb.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_glabels.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gpca_tag.h>

__BEGIN_DECLS

typedef struct _gdl_gpca_tag_result gdl_gpca_tag_result;

gdl_gpca_tag_result * gdl_gpca_tag_result_alloc (const gdl_gpca_tag_workspace * w);
void gdl_gpca_tag_result_free (gdl_gpca_tag_result * r);

size_t gdl_gpca_tag_result_size (const gdl_gpca_tag_result * r);
const gdl_mask * gdl_gpca_tag_result_mask (const gdl_gpca_tag_result * r);

gdl_gpca_tag_result * gdl_gpca_tag_result_fread (FILE * stream);
int gdl_gpca_tag_result_fwrite (FILE * stream, const gdl_gpca_tag_result * r);
int gdl_gpca_tag_result_fprintf (FILE * stream, const gdl_gpca_tag_result * r);

GDL_VAR const gdl_odriver * gdl_gpca_tag_result_driver;

__END_DECLS

#endif
