/*  
 *  gpca/registry.c 
 *  
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:42 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_gpca.h>

struct _gdl_gpca_workspace_type_registry
{
	gdl_hashtable * table;
};

static gdl_gpca_workspace_type_registry _singleton =
{
	NULL
};

const gdl_gpca_workspace_type_registry *
gdl_gpca_workspace_type_registry_get ()
{
	if (_singleton.table == NULL)
	{
		_singleton.table = gdl_hashtable_alloc (gdl_hash_default, 0);
		gdl_hashtable_add (_singleton.table, gdl_gpca_locus_allele_covariance->acronym, gdl_gpca_locus_allele_covariance, 0);
		gdl_hashtable_add (_singleton.table, gdl_gpca_locus_allele_correlation->acronym, gdl_gpca_locus_allele_correlation, 0);
		gdl_hashtable_add (_singleton.table, gdl_gpca_accession_allele_covariance->acronym, gdl_gpca_accession_allele_covariance, 0);
		gdl_hashtable_add (_singleton.table, gdl_gpca_accession_allele_correlation->acronym, gdl_gpca_accession_allele_correlation, 0);
		gdl_hashtable_add (_singleton.table, gdl_gpca_accession_allele_euclidean_distance->acronym, gdl_gpca_accession_allele_euclidean_distance, 0);
	}
	return &_singleton;
}

const gdl_gpca_workspace_type *
gdl_gpca_workspace_type_registry_search (const gdl_gpca_workspace_type_registry * r, const gdl_string * name)
{
	return (gdl_gpca_workspace_type *) gdl_hashtable_lookup (r->table, name);
}
